<?php
/**
 * The Header for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Fourteen
 * @since Twenty Fourteen 1.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    
    <meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE" />
    <link rel="icon" type="image/ico" href="<?php bloginfo('template_url'); ?>/images/favicon.png" /> 
   
    
   
    <!-- Font css --> 
    <link href="<?php bloginfo('template_url'); ?>/fonts/fonts.css" rel="stylesheet"/> 
   	<link href='https://fonts.googleapis.com/css?family=Roboto+Condensed:400,300italic,300,400italic,700,700italic' rel='stylesheet' type='text/css'>
        
	<!--[if IE]>
     	<script src="js/html5shiv.js"></script>
    <![endif]-->
    
    <!-- main script --> 
    <script src="<?php bloginfo('template_url'); ?>/js/jquery-1.9.1.min.js"></script>
    <!--<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>-->

    
    <!-- placeholder script --> 
    <script src="<?php bloginfo('template_url'); ?>/js/placeholder.js"></script>
    
    <!-- general script --> 
	<script src="<?php bloginfo('template_url'); ?>/js/script.js"></script>
    
    <!-- bx slider script -->
	<script src="<?php bloginfo('template_url'); ?>/js/owl.carousel.js" type="text/javascript"></script>
	<link href="<?php bloginfo('template_url'); ?>/css/owl.theme.css" rel="stylesheet" >
    <link href="<?php bloginfo('template_url'); ?>/css/owl.carousel.css" rel="stylesheet" >
    
     <!--royalslider stylesheets -->
	<script src="<?php bloginfo('template_url'); ?>/js/jquery.royalslider.min.js" ></script>
    <link href="<?php bloginfo('template_url'); ?>/css/royalslider.css" rel="stylesheet">
    <link href="<?php bloginfo('template_url'); ?>/css/rs-default.css" rel="stylesheet">
    
    
    
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
	<?php  wp_head(); ?>
     <!-- responsive css --> 
    <link href="<?php bloginfo('template_url'); ?>/css/responsive.css" rel="stylesheet" />
 </head>

<body <?php body_class(); ?>>
<!-- Google Tag Manager -->
<noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-MDDMX7"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MDDMX7');</script>
<!-- End Google Tag Manager -->


<!-- Mobile Navigation part html --> 
<div class="mobile-nav-block">
    <div class="nav-content">
    	<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu ', 'menu_id' => 'primary-menu','container'=> '' ) ); ?>
     	
    </div>
</div>
<!-- start --> 
<div id="wrapper">
	
    <!-- header part --> 
    <header>
    
     <?php $postid = get_the_ID();
     
     // echo $postid; ?> 
     
    
 <div class="header-top cf" style="background:#fff url(<?php if(get_field('header_banner_image')) { echo  get_field('header_banner_image', $postid);  } elseif(is_home()) {  echo  get_field('header_banner_image', 19);?> <?php } else { bloginfo('template_url')?>/images/header-top-bg.jpg<?php } ?>) no-repeat;" >
    
    	 <!-- <div class="header-top cf" style="background:#fff url(<?php //  the_field('header_banner_image',"options");  ?>) no-repeat;" > -->
            <div class="container cf">
              <?php if( get_field('header_logo',"options") ): ?><a  class="logo" href="<?php echo site_url(); ?>"><img src="<?php the_field('header_logo',"options"); ?>" /></a><?php endif; ?>
	            <div class="header-contact">
                	<div class="header-right">
                             <?php $loginCheck = $_COOKIE["user_login_chk"];
                                  if($loginCheck != NULL) { ?>
                		      <a class="link member" href="<?php echo site_url(); ?>/intranet/logout">member logout</a>
                             <?php } else { ?>
                		      <a class="link member" href="<?php echo site_url(); ?>/intranet">member login</a>
                             <?php } ?>
                  		<a class="link contact" href="<?php echo site_url(); ?>/contact/">contact us</a>
                  	</div>
                </div>
                <div class="mobile-btn-block">
                    <a class="btn-m-nav" href="#"></a>
                </div>
            </div>
        </div>
        <div class="header-bottom cf">
        	<div class="container cf">
            	<p><em><?php the_field('banner_tagline',"options"); ?></em></p>
            </div>
        </div>
		<!-- navigation part -->
        <nav>
 	<?php  wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu container', 'menu_id' => 'primary-menu','container'=> '' ) ); ?>
            
        </nav>
     </header>

