@extends('layout.default')
@section('content')
@include('elements.header')
<div id="container" class="row-fluid list-page">
@include('elements.left_sidebar')

<div id="main-content">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span12">
				<div class="hidden-phone" id="theme-change"><i class="icon-cogs"></i><span class="settings"><span class="text">Theme:</span><span class="colors"><span data-style="default" class="color-default"></span><span data-style="gray" class="color-gray"></span><span data-style="purple" class="color-purple"></span><span data-style="navy-blue" class="color-navy-blue"></span></span></span></div>
				<h3 class="page-title"> Online Personal Lemurian Record Instructions</h3>
				<ul class="breadcrumb">
					<li><a href=""><i class="icon-home"></i></a><span class="divider">&nbsp;</span></li>
					<li><a href="javascript:;">Instructions</a><span class="divider-last">&nbsp;</span></li>
				</ul>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12 sortable">
				<div class="widget">
					<div class="widget">
                    	<div class="widget-title">
                    		<h4>
                    			<i class="icon-globe">
                    			</i>
                    			Online Personal Lemurian Record Instructions
                    		</h4>
                    		<!--span class="tools">
                    			<a class="icon-chevron-down" href="javascript:;"></a>
                    			<a class="icon-remove" href="javascript:;"></a>
                    		</span--->
                    	</div>
                    	<div class="widget-body">
                    		<!--bodytext-->

                            <!-- TRANSACTION ENTRY FORM  -->

                            <p class="title">Online Personal Lemurian Record Instructions</p>
                            <p>The complete instructions for using the Personal Lemurian Record (PLR) are included in Lesson Two. However, there are a few things to mention for using the online version of the PLR.</p>
                            <p><b><i>Entering Dollar or Cent Amounts</i></b>: Dollar or cent amounts should <i>not </i>include a dollar sign ($) or comma (,).</p>
                            <p><b><i>Saving Your Entry</i></b>: After manually entering data, you must Click “Add Record,” “Update” “Update Record” or “Submit” for your entries to be saved.</p>
                            <p><b><i>The online PLR includes two options</i></b> – One to enter information (PLR Entry) and the other to view your Records (View Record):</p>
                            <p><b><i>PLR Entry</i></b> button – This is where you choose to enter your Non-Tithe Income, Tithe Income, and Expenses. Enter your information as follows:</p>
                            
                            <ol>
                             <li>Select the Transaction Type: “Non-Tithe Income,” “Tithe Income” or “Expense.” (Note: See Lesson Two “How to Keep Your Personal Lemurian Record” sub-title “Income and Contribution Record” for an explanation of Tithe and Non-Tithe Income).</li>
                             <li>Select the Month and the Year you wish this data to go into.
                             <ol class="lower-alpha">
                            	<li>Enter a User Defined Category.</li>
                            	<li>Enter a User Defined Description.</li>
                            	<li>Enter a Dollar amount.</li>
                            	<li>Click “Add Record.” The program will automatically calculate the amounts for Non-Tithe Income, Tithe Income and Expenses and will transfer those amounts to the various Records: Income and Contribution Record, Expense Record, and Summary/Security Fund Record. (Note: Enter “Amount Borrowed” and “Amount Paid (to you) Against Loan” as Non-Tithe Income.)</li>
                             </ol>
                            </li>
                            <li>Return to the PLR Main Menu:</li>
                            <li>Under “View Record” select the Month and Year and the Income and Contribution Record.
                             <ol class="lower-alpha">
                            	<li>Manually enter the percentage (%) of your tithe and manually enter a gift offering, if you wish.</li>
                            	<li>Click “Update.” The program will do the calculations.</li>
                             </ol>
                            </li><li>Under “View Record” select the Month and Year and the Summary/Security Fund Record.
                             <ol class="lower-alpha">
                            	<li>Manually enter the Working Fund you began the month with (Line 1), if you carry this forward from the previous month.</li>
                            	<li>Manually enter any amount you add to your Reserve and/or that you paid against a loan (Line 6).</li>
                            	<li>Manually enter when you add your Security Fund to your Working Fund (Line 8) or to your Reserve (Line 9). The figure on Line 8 or 9 cannot be greater than $60.00.</li>
                            	<li>Manually enter the Working Fund you end the month with (Line 12) or at any time during the month if you wish to check your accuracy. Click “Submit” and the program will let you know if you have an Overage or Shortage (Line 11).</li>
                            	<li>On the Summary/Security Fund Record, under Security Fund, manually enter the Amount of your SF that you carry forward from the previous month (4.00, 8.00, 16.00, or 32.00). Manually enter the amount (increment) you add to your SF this month. Click “Submit” and the program will calculate the amount of your SF and will transfer that amount to the Summary Record (Line 7).</li>
                             </ol>
                            </li>
                            </ol>
                            
                            <p><b><i>PLR “View Record”</i></b> button – This is where you can call up your PLR Records for each month. You can Edit your Records. You can also print your Records, if you wish.</p>
                            
                            <ol class="record">
                             <li>Select the Month and the Year.</li>
                             <li>Select the Income and Contribution Record, Expense Record, or Summary/Security Fund Record you wish to view.</li>
                             <li>Click “View Record.”</li>
                            </ol>
                            
                            <p><input type="button" onclick="window.location.href=ADMIN_URL+'plr-accounting';" class="btn back_table btn-success form-submit" value="Back to listing" /></p>
                             
                            
                            
                            <p>&nbsp; </p>
                    	</div>
                    </div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
</div>
</div>
</div>
@include('elements.footer')
@include('elements.cropbox', array('upload_folder'=>USER_IMG_PATH))
<?php Session::remove('message'); ?>
@endsection