@extends('layout.default')
@section('content')
@include('elements.header')
<div id="container" class="row-fluid">
   @include('elements.left_sidebar')
	<div id="main-content">
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="span12">
					<div id="theme-change" class="hidden-phone">
						<i class="icon-cogs"></i>
						<span class="settings">
							<span class="text">Theme:</span>
							<span class="colors">
								<span class="color-default" data-style="default">
								</span>
								<span class="color-gray" data-style="gray">
								</span>
								<span class="color-purple" data-style="purple">
								</span>
								<span class="color-navy-blue" data-style="navy-blue">
								</span>
							</span>
						</span>
					</div>
					<h3 class="page-title">My Profile</h3>
					<ul class="breadcrumb">
						<li>
							<a href="javascript:void(0);"><i class="icon-home"></i></a>
                            <span class="divider">&nbsp;</span>
						</li>						
						<li>
							<a href="javascript:void(0);">My Profile</a>
                            <span class="divider-last">&nbsp;</span>
						</li>						
					</ul>
				</div>
			</div>
			<div id="page" class="dashboard">
                <div class="row-fluid">
					<div class="span12">
						<div class="widget">
							<div class="widget-title">
								<h4><i class="icon-reorder"></i>My Profile</h4>
                                <h4 class="flash-inner-error"><?php echo Session::get('message') ?></h4>
							</div>
							<div class="widget-body form">

								{{ Form::open( array('action' => 'profile','id' => 'myprofileform','name' => 'myprofileform','class'=>'form-horizontal','onsubmit'=>'return false;') ) }}

								<div class="control-group">
									<label class="control-label">First Name:<b class='redMsg'>*</b></label>
									<div class="controls">

										{{ Form::text('v_first_name', $record->v_first_name, array('id' => 'v_first_name','class'=>'span6 required','tabindex'=>'1','maxlength'=>'30','size'=>'45','placeholder'=>'First Name')) }}

									</div>
								</div>
                                <div class="control-group">
									<label class="control-label">Last Name:<b class='redMsg'>*</b></label>
									<div class="controls">

										{{ Form::text('v_last_name', $record->v_last_name, array('id' => 'v_last_name','class'=>'span6 required','tabindex'=>'1','maxlength'=>'30','size'=>'45','placeholder'=>'Last Name')) }}

									</div>
								</div>
                                	
                                <div class="control-group">
									<label class="control-label">Email Id:<b class='redMsg'>*</b></label>
									<div class="controls">
										{{ Form::text('v_email', $record->v_email, array('id' => 'v_email','class'=>'span6 required','tabindex'=>'2','maxlength'=>'255','size'=>'45','placeholder'=>'Email Id'))}}
                                        <div class="error-exist" id="v_email_duplicate_error"></div>
									</div>
								</div>	
								<hr>
								<?php if(Auth::user()->e_type == 'Student'){ ?>
                                <div class="control-group">
									<label class="control-label">Current Password</label>
									<div class="controls">
										{{ Form::password('v_current_password', array('id' => 'v_current_password','class'=>'span6 validate_password','tabindex'=>'3','size'=>'45','placeholder'=>"Current Password",'maxlength'=>'255')) }}
                                        <div class="error-exist" id="v_current_password_duplicate_error"></div>                                        
                                	</div>
								</div>
                                <h5 style="color: #000;">Note: New password must have atleast one uppercase letter,  one lower case letter , one digit and one of !@#$%&*().</h5>
                                <div class="control-group">
    								<label class="control-label">New Password</label>
									<div class="controls">
										{{ Form::password('v_password1', array('id' => 'v_password1','class'=>'span6 user_password validate_password_custom','tabindex'=>'3','size'=>'45','placeholder'=>"Password",'maxlength'=>'255')) }}
									</div>
								</div>
                                <?php } else {?>
                                <div class="control-group">
    								<label class="control-label">New Password</label>
									<div class="controls">
										{{ Form::password('v_password1', array('id' => 'v_password1','class'=>'span6','tabindex'=>'3','size'=>'45','placeholder'=>"Password",'maxlength'=>'255')) }}
									</div>
								</div>
                                <?php } ?>							
								<div class="control-group">
									<label class="control-label">Confirm Password</label>
									<div class="controls">
										{{ Form::password('confirmpassword', array('id' => 'confirmpassword','class'=>'span6','tabindex'=>'4','equalTo'=>'#v_password1','size'=>'45','placeholder'=>"Confirm Password",'maxlength'=>'255')) }}
									</div>
								</div>
                                <div class="form-actions">
									{{ Form::button('Submit',array('id'=>'btn_submit_profile','name'=>'btn_submit_profile','type'=>'submit','class' => 'btn btn-success btn-submit','div'=>false)) }}

									<button type="button" onclick="window.location.href=ADMIN_URL+'dashboard';" id="redirect-to-home" class="btn">Cancel</button>
								</div>
								</form>
							</div>
						</div>
					</div>
				</div>								
			</div>
		</div>
	</div>
</div>
<script>
$(document).ready(function(){
   $(".validate_password_custom").keyup(function(){
        if($(this).val() != ''){
            $("#v_current_password").addClass('required');
        } else {
            $("#v_current_password").removeClass('required');
        }
   }); 
});

handleProfileForm();</script>
@include('elements.cropbox', array('upload_folder'=>USER_IMG_PATH))
@include('elements.footer')
@stop