@extends('layout.default') 
@section('content') 
@include('elements.header')
<div id="container" class="row-fluid list-page">
	@include('elements.left_sidebar')
	<div id="main-content">
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="span12">
					<h3 class="page-title">
						Lessons List
					</h3>
					<ul class="breadcrumb">
						<li>
							<a href=""><i class="icon-home"></i></a>
							<span class="divider">
								&nbsp;
							</span>
						</li>
						<li>
							<a href="#">Lessons List</a>
							<span class="divider-last">
								&nbsp;
							</span>
						</li>
						<li class="pull-right search-wrap">
						</li>
					</ul>
				</div>
				<div class="widget search-widget">
					<div class="widget-title">
						<h4>
							<i class="icon-reorder">
							</i>
							Search
						</h4>
					</div>
					<div class="widget-body">
						<div class="row-fluid">
							{{ Form::open( array('url' => ADMIN_URL.'review-lessons/list-ajax','id' => 'frmSearchForm','name' => 'frmSearchForm','onsubmit'=>'return false;') ) }}
							<div class="span12">
								<div class="dataTables_filter span3">
									<label>
										Member Name:
									</label>
									<select id="member_id" name="member_id" class="search">
										<option value="">--Select--</option>
									    @foreach($memberList as $key => $val)
                                            <option value="{{$val['id']}}">{{$val['v_last_name']."&nbsp;".$val['v_first_name']}}</option>
                                        @endforeach
                                    </select>
								</div>
								<div class="dataTables_filter span3">
									<label>Lesson Number:</label>
									<select id="lesson_id" name="lesson_id" class="search">
										<option value="">--Select--</option>
									    @foreach($lession_levels as $key=>$val)
                                            <option value="{{$key}}">{{$val}}</option>
                                        @endforeach
                                    </select>
								</div>
                                <div class="dataTables_filter span3">
									<label>
										Lessons Status:
									</label>
									<select id="e_status" name="e_status" class="search">
										<option value="">--Select--</option>
										<option value="Saved">Saved</option>
                                        <option value="Submitted">Submitted</option>
                                        <option value="Reviewed">Reviewed</option>
                                        <option value="Partial Submitted">Partial Submitted</option>
                                        <option value="Partial Reviewed">Partial Reviewed</option>
									</select>
								</div>
								<div class="dataTables_filter span3">
									<label>
										&nbsp;
									</label>
									<input type="button" value="Search" id="btn_submit" class="btn btn-success btn_submit form-submit">
									<input type="button" value="Show All" id="btn_showall" class="btn btn-success btn_show_all">
								</div>
							</div>
							<input type="hidden" id="rec_per_page" name="rec_per_page" value="<?php 
							if(Session::has('REC_LIMIT')) { echo Session::get('REC_LIMIT');
							} else {
							$NumOfRecords =get_num_of_rec_list();
							echo $NumOfRecords[0]; } ?>" />
							<div style="clear: both;">
							</div>
							<input type="hidden" id="last-loaded-page" name="last-loaded-page" value="" />
							<input type="hidden" id="view_url" name="view_url" value="<?php echo ADMIN_URL.'review-lessons/view/'; ?>" />
							<input type="hidden" id="del_url" name="del_url" value="<?php echo ADMIN_URL.'review-lessons/delete/'; ?>" />
						</div>
					</div>
				</div>
			</div>
			<div class="widget" id="widget-body-inner-content">
			</div>
			<div class="widget" id="widget-view-inner-content">
			</div>
		</div>
	</div>
</div>
@include('elements.footer') @include('elements.cropbox', array('upload_folder'=>USER_IMG_PATH))
<script>
loadPiece($("#frmSearchForm").attr('action'));
</script>
@endsection