<div class="widget-title">
    <h4><i class="icon-reorder"></i> Accounting Record List</h4>
    <h4 class="flash-inner"><span class="greenMsg flash-msg">{{Session::get('message')}}</span></h4>
    <span class="tools">
            <a href="{{ action('AccountController@anyPayment',array('transaction_type'=>strtolower($transaction_type)))}}">
            @if($transaction_type == 'Tuition')
                Submit a payment
            @else
                Submit a donation
            @endif
            </a>
    </span>
</div>
<div class="widget-body">
    <?php 
        if(count($records)>0) { ?>
            <form method="post" action="<?php echo ADMIN_URL.'accounting-list/bulk-actions'; ?>" name="recordListForm" id="recordListForm">
            <table width="100%">
                <tr>
                    <td>
                        <select class="input-mini record_page">
                        <?php 
                        foreach($NumOfRecords as $Num) {
                            echo '<option value="'.$Num.'"';
                            if($rec_per_page == $Num) { echo "selected=selected"; }
                            echo '>'.$Num.'</option>';
                        } ?>
                        </select> records per page
                    </td>
                    <td class="action-icon-help" align="right">Print&nbsp;<a><i class="icon-print"></i></a></td>
                </tr>
            </table>
            <table class="table table-striped table-bordered" id="sample_1">
                <thead>
                    <tr>
                      <th style="width:2px;"><input type="checkbox" class="group-checkable" id="check_all" data-set="#sample_1 .checkboxes" /></th>                                       <th class="short <?php echo ((isset($sort) && $sort=='d_tuition_transaction_date' && $order=='desc')?'sorting_asc':'sorting_desc'); ?>">
                        <a class="sort" href="{{URL::to('student-accounting-list-ajax?sort=d_tuition_transaction_date'.$querystr)}}">Transaction Date</a></th>
                        <th class="hidden-phone short <?php echo ((isset($sort) && $sort=='f_tuition_payment_received' && $order=='desc')?'sorting_asc':'sorting_desc'); ?>">
                        <a class="sort" href="{{URL::to('student-accounting-list-ajax?sort=f_tuition_payment_received'.$querystr)}}">Amount</a></th>
                        <th class="short <?php echo ((isset($sort) && $sort=='e_transaction_type' && $order=='desc')?'sorting_asc':'sorting_desc'); ?>">
                        <a class="sort" href="{{URL::to('student-accounting-list-ajax?sort=e_transaction_type'.$querystr)}}">Transaction Type</a></th>
                        <th class="none-short">Action</th>
                    </tr>
                </thead>
                <tbody id="tbody_drag">
                <?php foreach($records as $records_key => $records_value){ ?>
                    <tr class="odd gradeX" id="ApplicantRow-<?php echo $records_value->id; ?>">
                        <td><input type="checkbox" class="checkboxes" name="data[]" value="<?php echo $records_value->id; ?>" id="idval<?php echo $records_value->id; ?>" /></td>
                        @if($records_value->e_transaction_type =='Donation')
                            <td>{{ date('m/d/Y',strtotime($records_value->d_donation_sent_date)) }}</td>
                            <td>{{$records_value->f_donation_total_amt}}</td>
                        @else
                            <td>{{ date('m/d/Y',strtotime($records_value->d_tuition_transaction_date)) }}</td>
                            <td>{{$records_value->f_tuition_payment_received}}</td>
                        @endif
                        <td>{{$records_value->e_transaction_type}}</td>
                        <td>
                            <a target="_blank" href="{{ADMIN_URL.'student-accounting-details-print/'.$records_value->id}}" title="Print" href="javascript:void(0)" rel="<?php echo $records_value->id;?>"><i class="icon-print"></i></a>
                        </td>
                    </tr>
                   <?php } ?> 
                </tbody>
             </table>
                        
<?php } else {
    echo '<label class="redMsg">No record found.</label>';
}
    
if(count($records)>0) { ?>
<!--  start paging..................................................... -->
<div class="row-fluid">
    <div class="span2 dataTables_info">
        <select class="bulk-actions" name="bulk_action">
            <option value="">Select action</option>
            <option value="del">Delete Selected</option>
        </select> 
    </div>
    <div class="span6" style="margin-top: 13px;"><div class="dataTables_info"><?php echo 'Showing '.$pagnotr->getFrom().' to '.$pagnotr->getTo().' from '.$pagnotr->getTotal(); ?> </div></div>
    <div class="span4">
        <div class="dataTables_paginate paging_bootstrap pagination">
            <ul> {{$pagination}}</ul>
        </div>
    </div>
</div>
<!--  end paging................ -->
<?php } ?>
</div>
</form>  
<script type="text/javascript">
$(document).ready(function()
{
        setTimeout(function(){
            $(".flash-msg").html('');
            $(".flash-inner .greenMsg").html('');
            $(".greenMsg").fadeOut('slow'); 
        },3000);
});
</script>
<?php Session::remove('message'); ?>