<?php
Route::get('/', function()
{
	return View::make('hello');
});


//After Login 
Route::group(array('before' => 'auth'), function()
{
    //Uploade File
    Route::post('/upload-file',array('uses' => 'MembersAuthenticateController@postUploadFile'));
    Route::post('/create_dept_img_thumb',array('uses' => 'MembersAuthenticateController@create_dept_img_thumb'));// Crop image
    Route::get('/delete_temp_img/{img}',array('uses' => 'MembersAuthenticateController@delete_temp_img'));// Crop image
    Route::get('/dashboard',array('as' => 'dashboard','uses' => 'MembersAuthenticateController@dashboard'));
    Route::any('/start_import',array('as' => 'start_import','uses' => 'DatabaseImportController@start_import'));
    Route::any('/import',array('as' => 'import_function','uses' => 'DatabaseImportController@import_function'));
    
    Route::any('/policy-and-terms-acceptance',array('as' => 'policy-and-terms-acceptance','uses' => 'MembersAuthenticateController@anyPolicyAndTerms'));
    Route::any('/policy-and-terms-print',array('as' => 'policy-and-terms-print','uses' => 'MembersAuthenticateController@anyPolicyAndTermsPrint'));
    Route::any('/security-question',array('as' => 'security-setup','uses' => 'MembersAuthenticateController@anySecurityQuestion'));
    
    Route::any('/profile',array('as' => 'profile','uses' => 'MembersAuthenticateController@myProfile'));
    Route::any('/setting',array('as' => 'settings','uses' => 'MembersAuthenticateController@setting'));
    Route::get('/logout',array('uses' => 'MembersAuthenticateController@logout'));
    
    Route::any('/download_file',array('as'=>'download_file','uses'=>'MembersAuthenticateController@getDownloadFile'));
    /*User Section Start*/
    Route::controller('member','MemberController');
    Route::controller('accounting-list','AccountController');
    Route::get('/accounting-list/',array('as'=>'accounting-list','uses'=>'AccountController@getIndex'));
    Route::any('/accounting-list-ajax/',array('as'=>'accounting-list-ajax','uses'=>'AccountController@anyListAjax'));
    Route::any('/accounting-record-list/{id}',array('as'=>'accounting-record-list','uses'=>'AccountController@accountingRecordIndex'));
    Route::any('/accounting-record/add/{id?}/{last_url?}',array('as'=>'accounting-record-add','uses'=>'AccountController@accountingRecordAdd'));
    Route::any('/accounting-record/edit/{id}/{time?}',array('as'=>'accounting-record-edit','uses'=>'AccountController@accountingRecordEdit'));
    Route::any('/accounting-record/list-ajax/{id}',array('as'=>'accounting-record-list-ajax','uses'=>'AccountController@accountingRecordListAjax'));
    Route::any('/accounting-record/view/{id}',array('as'=>'accounting-record-view','uses'=>'AccountController@accountingRecordView'));
    Route::any('/accounting-record/delete/{id}',array('as'=>'transaction-delete','uses'=>'AccountController@deleteTransaction'));
    
    Route::get('/student-accounting-list/{type?}',array('as'=>'student-accounting-list','uses'=>'AccountController@getStudentAccountList'));
    Route::any('/student-accounting-list-ajax',array('as'=>'student-accounting-list-ajax','uses'=>'AccountController@anyStudentAccountListAjax'));
    Route::any('/student-accounting-details-print/{id}',array('as'=>'student-accounting-list-ajax','uses'=>'AccountController@anyStudentAccountDetailPrint'));
    Route::any('/student-account/payment/{type?}',array('as'=>'student-account-payment','uses'=>'AccountController@anyPayment'));
    
    Route::controller('review-lessons','AdminLessonsController');
    Route::controller('student-lessons','StudentLessonsController');
    Route::controller('messages','MessageController');
    Route::controller('plr-accounting','PlrAccountController');
});

//Before Login 
Route::group(array('before' => 'guest'),function(){
    
	Route::post('/index',array('as' => 'form-admin-login-post','uses' => 'MembersAuthenticateController@postIndex'));
    Route::get('/',array('as' => 'form-admin-login','uses' => 'MembersAuthenticateController@index'));    
    
    Route::post('/form-admin-forgot',array(
	    'as' => 'form-admin-forgot',
	    'uses' => 'MembersAuthenticateController@forgot_password_email'
	));
    Route::any('/security_question/{code}',array(
	    'as' => 'form-admin-forgot-security',
	    'uses' => 'MembersAuthenticateController@forgot_password_security'
	));
    Route::any('/reset_password/{code}',array(
				'as'=>'reset-password',
				'uses'=>'MembersAuthenticateController@reset_password'
		    	));
});

//Front Side Routeterms-conditions
    
    App::missing(function($exception)
    {
        return Redirect::action('MembersAuthenticateController@dashboard');
    });
?>