<?php
use Illuminate\Auth\UserTrait;
use Illuminate\Auth\UserInterface;
use Illuminate\Auth\Reminders\RemindableTrait;
use Illuminate\Auth\Reminders\RemindableInterface;

class Member extends Eloquent implements UserInterface, RemindableInterface {

	use UserTrait, RemindableTrait;

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'tbl_members';

	/**
	 * The attributes excluded from the model's JSON form.
	 *
	 * @var array
	 */
    public $timestamps = false;
	protected $hidden = array('password', 'remember_token');
    
    public function lesson()
    {
        return $this->belongsto('Lesson','i_lesson_id');
    }
    public function member_lesson()
    {
        return $this->hasMany('MemberLesson','i_member_id');
    }
    public function messages()
    {
        return $this->hasMany('Message','i_member_id');
    }
    public function delete() {
        $this->member_lesson()->delete();
        $this->messages()->delete();
        return parent::delete();
    }
}?>