<?php
class StudentLessonsController extends BaseController
{
    protected $returnIds = array(); // return active,inactive, delete ids array
    
    public function getIndex() // Index
    {
        if (Auth::check() && Auth::user()->i_agreed == '0' && Auth::user()->e_type == 'Student') {
            return Redirect::to(ADMIN_URL.'policy-and-terms-acceptance');  
        }
        if (Auth::check() && Auth::user()->id != '1' || Auth::user()->e_type == 'Student') {
            return View::make('student-lessons.index')->with(array('title' => 'Lessons List'));
        } else {
                return Redirect::to('dashboard');
        }
    }

    public function anyListAjax() //User Listing
    {
        $query = MemberLesson::query();
        $Requestdata = Input::all();
        $sortBy = array('v_lesson');
        
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'id';
        $order       = Input::get('order') === 'asc' ? 'desc' : 'asc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if ($rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if (isset($lesson_id) && $lesson_id != "") {
            $query->where("tbl_member_lesson.i_lesson_id", $lesson_id);
        }
        if (isset($e_status) && $e_status != "") {
            $query->where("tbl_member_lesson.e_status", $e_status);
        }
        $query->join('tbl_lesson', 'tbl_lesson.id', '=', 'tbl_member_lesson.i_lesson_id');
        $query->select('tbl_lesson.id as lesson_id','tbl_lesson.v_lesson','tbl_lesson.e_status as lesson_status','tbl_lesson.v_file_link as file_link','tbl_member_lesson.id as member_lesson_id', 'tbl_member_lesson.e_status as member_lesson_status','tbl_member_lesson.*');
        $lession_leavel_count = Auth::user()->i_lesson_id;
        $lessionLeavelArr = range(1,$lession_leavel_count);
        $lession_leavel = array_values($lessionLeavelArr);
        $query->whereIn('i_lesson_id',$lession_leavel);
        $query->where('i_member_id',Auth::user()->id);
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        $NumOfRecords = get_num_of_rec_list();
        
        return View::make('student-lessons.list_ajax')->with(array(
            'records' => $records->toArray(),
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'pagnotr'       =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }
    public function anyAdd() //Lesson edit section
    {
        if (Input::all()) {
            if($lesson->save())
            {
                Session::put('message',ADD_SUCCESS);
            }
        } else {
            return View::make('student-lessons.add');
        }
    }

    public function anyEdit($id = '') //Lesson edit section
    {
        if (Input::all()) {
            $input = Input::all();
            /** Change lessson Status **/
            $memberSection = MemberLesson::where('i_lesson_id',$input['lesson_id'])->where('i_member_id',Auth::user()->id)->first();
            $lastStatus = $memberSection->e_status;
            $memberSection->e_status = $input['lesson_status'];    
            if($input['lesson_status'] == 'Submitted' || $input['lesson_status'] == 'Partial Submitted')
            {
               $memberSection->d_submitted_date = date('Y-m-d H:m:i');
            }
            $memberSection->updated_at = date('Y-m-d H:m:i');
            $memberLessonID = $memberSection->id;
            $memberSection->save();
            if(($lastStatus != 'Submitted' && $input['lesson_status'] == 'Submitted') || ($lastStatus != 'Partial Submitted' && $input['lesson_status'] == 'Partial Submitted'))
            {
                $member = Member::where('e_type','Admin')->first();
                $userName = Auth::user()->v_first_name." ".Auth::user()->v_last_name;
                /** Send Mail to admin that user submited a new lession*/
                $this->send_mail_to(5,$member,$userName); // Template Id and MemberInfo
            }
            /** Save Lesson Answer **/
            $arrData = array('_token','lesson_id','lesson_status');
            foreach($input as $key => $val){
                if(!in_array($key,$arrData)){
                    $memberLessonAnswer = MemberLessonAnswer::where('i_member_lesson_id',$memberSection->id)->where('i_lesson_question_id',$key)->first();
                    if(count($memberLessonAnswer) <= 0) {
                        $memberLessonAnswer = new MemberLessonAnswer; 
                    }   
                    $memberLessonAnswer->i_member_lesson_id = $memberLessonID;
                    $memberLessonAnswer->i_lesson_question_id = $key ; 
                    $memberLessonAnswer->v_question_answer = $val ; 
                    $memberLessonAnswer->save();        
                }
            }
            Session::put('message',EDIT_SUCCESS);
            return '';
        } else {
            $memberLesson = MemberLesson::where('i_lesson_id',$id)->where('i_member_id',Auth::user()->id)->first()->toArray();
            /** First Time Edit With Question List **/
            $lessonDetails = Lesson::where('id',$id)->first()->toArray(); 
            /** Current Lesson Details **/
            $allQuestionAnswer = $this->get_question_answer_array($id,$memberLesson['id']);
            /** Get Question and There Answer List **/
            
            /*if($memberLesson['e_status'] == 'Start')
            {
                $lessonQuestions = Lesson::where('id',$id)->with(array('lesson_question' => function($lesson_question) use($id){
                    $lesson_question->where('i_lesson_id',$id);
                }))->first()->toArray();
                
                return View::make('student-lessons.edit')->with(array('record' => $lessonQuestions,'memberLesson'=>$memberLesson,));
            }*/
            /** All Question With Saved Answer List Editable **/
            if($memberLesson['e_status'] == 'Saved' || $memberLesson['e_status'] == 'Partial Submitted')
            {
                return View::make('student-lessons.edit-answer')->with(array('record' => $allQuestionAnswer,'lessonDetails'=>$lessonDetails));
            }
            else if($memberLesson['e_status'] == 'Partial Reviewed')
            {
                return View::make('student-lessons.partial-answer')->with(array('record' => $allQuestionAnswer,'lessonDetails'=>$lessonDetails,'memberLesson'=>$memberLesson));
            }
            /** All Question With Saved Answer List Non Editable
            **/
            else if($memberLesson['e_status'] == 'Submitted' || $memberLesson['e_status'] == 'Reviewed')
            {
                return View::make('student-lessons.view')->with(array('record' => $allQuestionAnswer,'memberLesson'=>$memberLesson,'lessonDetails'=>$lessonDetails));
            }
            else {
                $lessonQuestions = Lesson::where('id',$id)->with(array('lesson_question' => function($lesson_question) use($id){
                    $lesson_question->where('i_lesson_id',$id);
                }))->first()->toArray();
                return View::make('student-lessons.edit')->with(array('record' => $lessonQuestions,'memberLesson'=>$memberLesson,));
            }
       }
    }
    
    public function anyLessonInfoPrint($id)
    {
        $memberLesson = MemberLesson::where('i_lesson_id',$id)->where('i_member_id',Auth::user()->id)->first()->toArray();
        $allQuestionAnswer = $this->get_question_answer_array($id,$memberLesson['id']);
        
        return View::make('student-lessons.view')->with(array('title'=>'Lesson Print','record' => $allQuestionAnswer,'memberLesson'=>$memberLesson));
    }
    
    public function anyPrint($id) // Lesson Print
    {
        $memberLession = MemberLesson::where('id',$id)->with('member')->with('lesson')->first()->toArray();
        $allQuestionAnswer = $this->get_question_answer_array($memberLession['i_lesson_id'],$id); /** Get Question and There Answer List* ***/
        return View::make('lessons.print')->with(array('title'=>'Lesson Print', 'record' => $memberLession,'memberlessonAnswer'=>$allQuestionAnswer));
    }
    
    public static function get_question_answer_array($lessonID,$memberLessonID)
    {
        return  MemberLessonAnswer::where('i_member_lesson_id',$memberLessonID)->with(array('lesson_question' => function($lesson_question) use($lessonID){
            $lesson_question->where('i_lesson_id',$lessonID);
        }))->get()->toArray();
    }

}?>