<?php
class PlrAccountController extends BaseController
{
   protected $returnIds = array(); // return active,inactive, delete ids array
    
    public function getIndex() // Index
    {
        if (Auth::check() && Auth::user()->e_type == 'Student' ) {
            $yearList = $this->years_list();
            $monthList = $this->months_list();
            return View::make('plr.index')->with(array('title'=>'PLR Accounting','monthList'=>$monthList,'yearList'=>$yearList));
        } else {
                return Redirect::to('dashboard');
        }
    }

    public function anyListAjax() //PLR Accounting Listing
    {
        $currentUser = array();
        $currentUser = Auth::user();
        $currentUser = $currentUser->toArray();
        $query = Plr::query();
        $summary_status = '';
        $plrSummaryID = '';
        $Requestdata = Input::all();
        
        $sort = 'updated_at';
        $order       = 'asc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        $rec_per_page = '';
        if ($rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if ($e_transaction_type != "" && $e_transaction_type != 'summary') {
            if($e_transaction_type == 'income-contribution'){
                $query->where(function($query){
                    $query->where("tbl_plr.e_transaction_type",'Non Tithe Income');
                    $query->orWhere("tbl_plr.e_transaction_type",'Tithe Income');
                });
                $summary_status = 1;
            } else {
                $summary_status = 2;
                $query->where("tbl_plr.e_transaction_type",$e_transaction_type);    
            }
        } else{
            $summary_status = 3;
        }
        $query->where("tbl_plr.i_entry_month",$i_entry_month)->where("tbl_plr.i_entry_year",$i_entry_year)->where("tbl_plr.i_member_id",$currentUser['id'])->orderBy('tbl_plr.v_category','asc');
        $query->join('tbl_members', 'tbl_members.id', '=', 'tbl_plr.i_member_id');
        $query->select('tbl_members.id as member_id','tbl_members.v_first_name', 'tbl_members.v_last_name','tbl_plr.id as plr_id','tbl_plr.*');
        $query->orderBy($sort, $order);
        $records = $query->get();
        $titheIncomeTotal = '';
        $nonTitheIncomeTotal = '';
        $expenseTotal = '';
        $allRecord = array();
        $allRecord['tithe_income_total'] = 0;
        $allRecord['non_tithe_income_total'] = 0;
        $allRecord['expense_total'] = 0;
        foreach($records->toArray() as $key => $val)
        {
            if($val['e_transaction_type'] == 'Tithe Income')
            {
                $titheIncomeTotal = $titheIncomeTotal + $val['f_amount'];
                $allRecord['tithe_income'][$key] = $val;   
                $allRecord['tithe_income_total'] = $titheIncomeTotal;
            }
            else if($val['e_transaction_type'] == 'Non Tithe Income')
            {
                $nonTitheIncomeTotal = $nonTitheIncomeTotal + $val['f_amount'];   
                $allRecord['non_tithe_income'][$key] = $val;
                $allRecord['non_tithe_income_total'] = $nonTitheIncomeTotal;
            }
            else if($val['e_transaction_type'] == 'Expense')
            {
                $expenseTotal = $expenseTotal + $val['f_amount'];   
                $allRecord['expense'][$key] = $val;
                $allRecord['expense_total'] = $expenseTotal;
            }
        }
        $plrSummary = PlrSummary::where('i_member_id',Auth::user()->id)
                                ->where('i_entry_year',$i_entry_year)
                                ->where('i_entry_month',$i_entry_month)
                                ->get()->first();
        //pr($plrSummary);exit;
        $summaryFundRecord = array();
        
        $summaryFundRecord['netIncome'] = 0; $summaryFundRecord['tithePercentage'] = 0; $summaryFundRecord['tithePercentageAmount'] = 0; $summaryFundRecord['giftOfferingAmount'] = 0;
        
        $summaryFundRecord['gainLossMonth'] = 0; $summaryFundRecord['compBalanceEoM'] = 0; $summaryFundRecord['overShort']= 0; $summaryFundRecord['totAccSecFundEoM'] = 0; $summaryFundRecord['f_workingfundbm'] = 0; $summaryFundRecord['f_toreserve']= 0; $summaryFundRecord['f_secfundincrement']= 0; $summaryFundRecord['f_secfundtoworkfund']= 0;$summaryFundRecord['f_secfundtoreserve']= 0; $summaryFundRecord['f_workingfundem']= 0; $summaryFundRecord['f_secfundpm'] = 0;
        if($summary_status == 1 && count($plrSummary) > 0 ||$summary_status == 3 && count($plrSummary) > 0)
        {
            $plrSummaryID = $plrSummary->id;
            /** For Income And Contibution Section****/
            $summaryFundRecord['tithePercentage'] = $plrSummary->f_tithepercentage;
            $summaryFundRecord['tithePercentageAmount'] = $allRecord['tithe_income_total'] * $summaryFundRecord['tithePercentage'] / 100;
            $summaryFundRecord['giftOfferingAmount'] = $plrSummary->f_giftoffering;
            if($allRecord['tithe_income_total'] != 0 || $allRecord['non_tithe_income_total'] != 0){
                $summaryFundRecord['netIncome'] = $allRecord['tithe_income_total'] - $summaryFundRecord['tithePercentageAmount'] - $summaryFundRecord['giftOfferingAmount'];
            }
            $summaryFundRecord['gainLossMonth'] = $summaryFundRecord['netIncome'] - $allRecord['expense_total'];
            /** Summary and Security Found Record****/
            $summaryFundRecord['compBalanceEoM'] = $plrSummary->f_workingfundbm + $allRecord['non_tithe_income_total'] + $summaryFundRecord['netIncome'] - $allRecord['expense_total'] - $plrSummary->f_toreserve - $plrSummary->f_secfundincrement + $plrSummary->f_secfundtoworkfund;    
            $summaryFundRecord['overShort'] = $plrSummary->f_workingfundem - $summaryFundRecord['compBalanceEoM'];
            $summaryFundRecord['totAccSecFundEoM']   = $plrSummary->f_secfundincrement + $plrSummary->f_secfundpm;
            $summaryFundRecord['f_workingfundbm'] =   $plrSummary->f_workingfundbm; 
            $summaryFundRecord['f_toreserve'] = $plrSummary->f_toreserve;
            $summaryFundRecord['f_secfundincrement'] = $plrSummary->f_secfundincrement;
            $summaryFundRecord['f_secfundtoworkfund'] = $plrSummary->f_secfundtoworkfund;
            $summaryFundRecord['f_secfundtoreserve'] = $plrSummary->f_secfundtoreserve;
            $summaryFundRecord['f_workingfundem'] = $plrSummary->f_workingfundem;
            $summaryFundRecord['f_secfundpm'] = $plrSummary->f_secfundpm; 
        }
        $summaryFundRecord['summary_id'] = $plrSummaryID;
        return View::make('plr.list_ajax')->with(array(
            'records' => $allRecord,
            'summaryFundRecord' => $summaryFundRecord,
            'summary_status' => $summary_status,
            'currentUser' => $currentUser,
            'i_entry_month' => $i_entry_month,
            'plrSummary' => $plrSummary,
            'i_entry_year' => $i_entry_year,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc')));
    }    
    
    public function anyAdd() // PLR Entry Add and Edit 
    {
        if (Input::all()) 
        {
            $input = Input::all();
            $plrRecord = new Plr;
            $plrRecord->i_member_id = Auth::user()->id;
            $plrRecord->e_transaction_type = $input['e_transaction_type'];
            $plrRecord->i_entry_month = $input['i_entry_month'];
            $plrRecord->i_entry_year = $input['i_entry_year'];
            $plrRecord->v_category = $input['v_category'];
            $plrRecord->v_description = $input['v_description'];
            $plrRecord->f_amount = round($input['f_amount']);
            $plrRecord->d_added_date = date('Y-m-d H:m:i');
            if($plrRecord->save())
            {
                $plrSummaryCount = PlrSummary::where('i_member_id',Auth::user()->id)
                                ->where('i_entry_year',$input['i_entry_year'])
                                ->where('i_entry_month',$input['i_entry_year'])
                                ->count();
                if($plrSummaryCount == 0){
                    $plrSummary = new PlrSummary;  
                    $plrSummary->i_entry_month = $input['i_entry_month'];
                    $plrSummary->i_entry_year = $input['i_entry_year'];
                    $plrSummary->i_member_id = Auth::user()->id;
                    $plrSummary->save();    
                }
                Session::put('message',ADD_SUCCESS); 
            }
        } else {
            $yearList = $this->years_list();
            $monthList = $this->months_list();
            return View::make('plr.add')->with(array('title'=>'New Transaction Entry','monthList'=>$monthList,'yearList'=>$yearList));
        }
    }

    public function anyEdit($id) //Plr Record edit section
    {
        if (Input::all()) {
            $input = Input::all();
            $plrRecord = Plr::find($id);
            $plrRecord->i_member_id = Auth::user()->id;
            $plrRecord->e_transaction_type = $input['e_transaction_type'];
            $plrRecord->i_entry_month = $input['i_entry_month'];
            $plrRecord->i_entry_year = $input['i_entry_year'];
            $plrRecord->v_category = $input['v_category'];
            $plrRecord->v_description = $input['v_description'];
            $plrRecord->f_amount = round($input['f_amount']);
            $plrRecord->updated_at = date('Y-m-d H:m:i');
            if($plrRecord->save())
            {
                Session::put('message',EDIT_SUCCESS);
                return '';
            }
        } else {
            $yearList = $this->years_list();
            $monthList = $this->months_list();
            $plrRecord = Plr::find($id);
            return View::make('plr.edit')->with(array('record' => $plrRecord->toArray(),'monthList'=>$monthList,'yearList'=>$yearList));
        }
    }
    
    public function getDelete($id)
    {
        if ($id != '') {
            $message = Message::find($id);
            $message->e_status = "Deleted";
            $message->save();
        }
    }
    public function anyUpdate()
    {
        if(Input::all()){
            $input = Input::all();
            //pr(Input::all());exit;
            if(isset($input['summary_id']) && $input['summary_id']!=''){
                $plrSummary = PlrSummary::find($input['summary_id']);
            } else {
                $plrSummary = new PlrSummary;  
            }
            if(isset($input['f_tithepercentage']) && isset($input['f_giftoffering'])){
                $plrSummary->f_tithepercentage = round($input['f_tithepercentage']);
                $plrSummary->f_giftoffering = $input['f_giftoffering'];    
            }
            if(isset($input['f_workingfundbm']) && isset($input['f_toreserve']) && isset($input['f_secfundtoworkfund'])){
                $plrSummary->f_workingfundbm = $input['f_workingfundbm'];
                $plrSummary->f_toreserve = $input['f_toreserve'];
                $plrSummary->f_secfundtoworkfund = $input['f_secfundtoworkfund'];
                $plrSummary->f_secfundtoreserve = $input['f_secfundtoreserve'];
                $plrSummary->f_workingfundem = $input['f_workingfundem'];
                $plrSummary->f_secfundpm = round($input['f_secfundpm']);
                $plrSummary->f_secfundincrement = round($input['f_secfundincrement']);
            }
            $plrSummary->i_entry_year = $input['i_entry_year'];
            $plrSummary->i_entry_month = $input['i_entry_month'];
            $plrSummary->i_member_id = Auth::user()->id;
            $plrSummary->save();
            Session::put('message',EDIT_SUCCESS);
            return '';
        }
    }
    
    public function anyInstructions() // Message Add and Edit 
    {
        return View::make('plr.instructions')->with(array('title'=>'Online Personal Lemurian Record Instructions'));
    }
    
    public static function months_list(){
      return array('1'=>'January', '2'=>'February', '3'=>'March', '4'=>'April', '5'=>'May', '6'=>'June', '7'=>'July', '8'=>'August', '9'=>'September', '10'=>'October', '11'=>'November', '12'=>'December');  
    }
    public static function years_list(){
      return array('2014'=>'2014','2015'=>'2015','2016'=>'2016','2017'=>'2017','2018'=>'2018','2019'=>'2019','2020'=>'2020');  
    }
}?>