<?php
class MembersAuthenticateController extends BaseController
{
   public static function get_num_of_rec_list()
    {
        return array(
            '10',
            '1',
            '5',
            '10',
            '20',
            '50',
            '100'); //$NumOfRecords
    }

    public function index()
    {
        $forgotpass_flag = '0';

        if (Session::get('FORGOTPASS_FLAG') == '1')
        {
            Session::set('forgotpass_flag', '1');
        }
        //pr(Input::all());exit;
        return View::make('members_authenticates.index', array('forgotpass_flag' => $forgotpass_flag,
       'title' => 'Login'));   
    }
    public function postIndex()
    {
        if (Input::all())
        {
            $remember = (Input::has('rememberme')) ? true : false;
            $auth = Auth::attempt(array( // method for checking authentication
                    'v_email'=>e(trim(Input::get('v_username'))),
                    'password'=>e(trim(Input::get('v_password'))),
            ),$remember);
            //$auth = Auth::attempt(array('v_email' => Input::get('v_username'), 'password' => Input::get('v_password')), $remember);
            if ($auth)
            {
                $admindata = Member::where('v_email',trim(Input::get('v_username')))->first()->toArray();
                //Session::set('user_login_chk', $admindata);
                $cookie_name = "user";
                $cookie_value = "Login_success";
                setcookie("user_login_chk",$cookie_value, time() + (86400 * 30), "/","www.lemurianfellowship.org"); 
                //setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day
                if($admindata['e_type'] == 'Admin'){                    
                    return Redirect::to(ADMIN_URL.'dashboard');  
                }
                else{
                    if($admindata['e_type'] == 'Student' && $admindata['i_agreed'] == 0){
                        return Redirect::to(ADMIN_URL.'policy-and-terms-acceptance');   
                    } else {
                        return Redirect::to(ADMIN_URL.'student-lessons');    
                    }
                }
            } else {
                Session::flash('message', ERR_PWS);
                return Redirect::to(ADMIN_URL);
            }
        }
    }

    public function forgot_password_email()
    {
        if (Input::all())
        {
            $user = Member::where('v_email', '=', trim(Input::get('v_username')))->first();
            if ($user != "")
            {
                $code = str_random(20);
                $user->code = $code;
                if ($user->save()){
                    if($user->v_security_question != '' && $user->v_security_answer !=''){
                        Session::set('SECURITY_QUESTION_FLAG','1');
                        return Redirect::to(SITE_URL.'security_question/'.$code);    
                    } else {
                        $this->send_reset_password_mail($user);
                        return Redirect::to(SITE_URL);
                    }
                }
            } else {
                Session::flash('message', INVALID_EMAIL);
                Session::set('FORGOTPASS_FLAG', '1');
                return Redirect::to(SITE_URL);
            }
        }
    }
    
    public function forgot_password_security($code)
    {
        $user = Member::where('code', '=',$code)->first();
        if(Input::all())
        {
            $security_answer = e(trim(Input::get('v_security_answer')));
            if($security_answer != "" && $security_answer == $user->v_security_answer)
            { 
                $this->send_reset_password_mail($user);
                return Redirect::to(SITE_URL);   
            } else {
                Session::flash('message',SECURITY_ANS_ERROR);
                return Redirect::to(SITE_URL.'security_question/'.$code);     
            }
        } else {
            $user = Member::where('code', '=',$code)->first();
            if(Session::has('SECURITY_QUESTION_FLAG') && $user != ''){
                return View::make('members_authenticates.security-question-frm')->with(array('title' =>
                    'Retrieve Your Password', 'user' => $user));
            } else {
                return Redirect::to(SITE_URL);
            }
        }
    }
    
    public function send_reset_password_mail($user){
        $objEmailTemplate = EmailTemplate::find(1);
        $emailSubject = $objEmailTemplate['v_template_subject'];
        $strTemplate = $objEmailTemplate['t_email_content'];
        $strTemplate = str_replace('[SITE_URL]',SITE_URL,$strTemplate);
        $strTemplate = str_replace('[SITE_NAME]',SITE_NAME,$strTemplate);
        $strTemplate = str_replace('[LINK]',URL::route('reset-password', $user->code),$strTemplate);
        $strTemplate = str_replace('[USERNAME]',$user->v_first_name." ".$user->v_last_name,$strTemplate);
        // mail sent to user with new link
        /*ob_end_clean();
        header("Connection: close");
        ignore_user_abort(); 
        ob_start();
        header('HTTP/1.1 200 OK', true, 200);
        echo "";
        $size = ob_get_length();
        header("Content-Length: $size");
        ob_end_flush();
        flush();
        session_write_close();*/
        Mail::send('emails.generate-email-template', array('strTemplate'=>$strTemplate), function($message) use ($user,$emailSubject)
        {
            $message->to($user->v_email, $user->v_first_name." ".$user->v_last_name);
            $message->replyTo(FROM_EMAIL_ADDRESS, FROM_EMAIL_ADDRESS_NAME);
            $message->subject($emailSubject);                        
        });
        Session::flash("message","<span class='greenMsg'>An email message with your password reset link was sent to ".$user->v_email.".</span>");
        if(Session::has('SECURITY_QUESTION_FLAG')){
            Session::remove('SECURITY_QUESTION_FLAG');
        }
        Session::remove('FORGOTPASS_FLAG');
    }
            
    public function reset_password($code)
    {
        if (Input::all())
        {
            $id = Input::get('id');
            $user = Member::find($id);
            $user->password = Hash::make(Input::get('password'));
            $user->code = '';
            $user->save();
            Session::put('message',PW_RESET_SUCCESS);
                 return Redirect::to('/');
        } else
        {
            $user = Member::where('code', '=',$code)->first();
            if (count($user) > 0)
            {
                return View::make('members_authenticates.reset_password')->with(array('title' =>
                        'Reset Password', 'user' => $user));
            } else{
                Session::put('message',PW_RESET_ERROR);
                return Redirect::to('/');
            }
        }
    }

    public function dashboard()
    {
        //pr($_COOKIE['user_login_chk']);
        if (Auth::check() && Auth::user()->e_type == 'Student') {
            return Redirect::to(ADMIN_URL.'student-lessons');  
        } else {
            $total_record = array();
            $total_record['members'] = Member::all()->count();
            $total_record['lesson_reviewed'] = MemberLesson::where('e_status', '=', 'Reviewed')->count();
            $total_record['lesson_submited'] = MemberLesson::where('e_status', '=', 'Submitted')->count();
            $total_record['lesson_new'] = MemberLesson::where('i_member_id', '=',Auth::user()->id)->where('e_status', '=', 'Start')->count();
            return View::make('members_authenticates.dashboard', array('title' => 'Dashboard','total_record'=>$total_record));    
        }
    }
    
    public function setting()
    {
        $setting = array();
        if(Input::all())
        {
            $defaultAmount->save();
            Session::flash('message', SETTING_SUCCESS);
            return Redirect::to(SITE_URL . "setting");
        }else {
            return View::make('members_authenticates.setting', array('title' => 'Settings', 'record' => $setting));    
        }
        
    }

    public function logout()
    {
        Auth::logout();
        if (isset($_SERVER['HTTP_COOKIE'])) {
            $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
            foreach($cookies as $cookie) {
                $parts = explode('=', $cookie);
                $name = trim($parts[0]);
                setcookie($name, '', time() -1000, "/","www.lemurianfellowship.org");  
                //setcookie($name, '', time()-1000);
                //setcookie($name, '', time()-1000, '/');    
            }
        }              
        Session::flash('message', LOG_SUCCESS);
        return Redirect::to(ADMIN_URL);
        exit();
    }

    public function myProfile()
    {
        $id = Auth::user()->id;
        $member = Member::find($id);
        if (Input::all())
        {
            $inputs = Input::all();
            $memberExits = Member::where('id','!=',$id)->where('v_email',$inputs['v_email'])->count();
            $duplicateError = array();
            if($memberExits > 0){
                $duplicateError['v_email'] =  "Email id already exits.";
            }
            if ($inputs['v_password1'] != "" && $inputs['confirmpassword'] && $inputs['v_password1'] ==  $inputs['confirmpassword'])
            {
                if($member->e_type == 'Student'){
                    if(Hash::check($inputs['v_current_password'], $member->getAuthPassword()))
                    {
                        $member->password = Hash::make($inputs['v_password1']);
                    } else {
                        $duplicateError['v_current_password'] =  "Current password not match.";
                    }    
                } else {
                    $member->password = Hash::make($inputs['v_password1']);
                }
            }
            if(count($duplicateError) > 0)
            {
                return $duplicateError;
                exit;
            }
            $member->v_first_name = trim($inputs['v_first_name']);
            $member->v_last_name = trim($inputs['v_last_name']);
            $member->v_email = trim($inputs['v_email']);
            $member->updated_at = date('Y-m-d H:m:i');
            $member->save();
            Session::flash('message', PROFILE_SUCCESS);
            return '';
        } else {
            return View::make('members_authenticates.profile', array('title' => 'Profile','record' => $member));
        }
        
    }

    public function postUploadFile()
    {
        //$this->package('vendor/blueimp', 'Blueimp');
        $button_name = Input::get('button_name');
        $min_width = Input::get('min_width');
        $min_height = Input::get('min_height');
        $max_width = Input::get('max_width');
        $max_height = Input::get('max_height');
        $options = array(
            'upload_dir' => FILE_UPLOAD_URL,
            'upload_url' => SITE_URL . 'files/',
            'script_url' => SITE_URL .'vendor/blueimp/jquery-file-upload/server/php/index.php',
            'param_name' => $button_name,
            'min_width' => $min_width,
            'min_height' => $min_height,
            'max_width' => $max_width,
            'max_height' => $max_height);

        if (Input::get('accept_file_types') && Input::get('accept_file_types') != "")
        {
            $options['accept_file_types'] = Input::get('accept_file_types');
        }
        $upload_handler = new UploadHandler($options);
        exit;
    }
    
    public function anyPolicyAndTerms()
    {
        if(Input::all()){
            $id = Auth::user()->id;
            $records = Member::find($id);
            $records->i_agreed = 1;
            $records->d_agreed_date = date('Y-m-d H:m:i');
            $records->save();
            return Redirect::to(ADMIN_URL.'security-question');
        } else {
            $pricyPolicy = Cms::find(1)->toArray();
            $terms = Cms::find(2)->toArray();
            return View::make('members_authenticates.policy-and-terms-acceptance', array(
                'title' => 'Terms of Use & Privacy Policy Acceptance',
                'pricyPolicy'=> $pricyPolicy,
                'terms' => $terms
            ));  
        }
    }
    
    public function anyPolicyAndTermsPrint()
    {
        $pricyPolicy = Cms::find(1)->toArray();
        $terms = Cms::find(2)->toArray();
        return View::make('members_authenticates.policy-and-terms-print', array(
            'title' => 'Print Terms of Use & Privacy Policy Acceptance',
            'pricyPolicy'=> $pricyPolicy,
            'terms' => $terms
        ));
    }
    
    public function anySecurityQuestion()
    {
        $id = Auth::user()->id;
        $record = Member::find($id);
        if(Input::all()){
            $record->v_security_question = e(trim(Input::get('v_security_question')));
            $record->v_security_answer = e(trim(Input::get('v_security_answer')));
            $record->save();
            Session::flash('message','<span class="greenMsg">Security question update successfully.</span>');
            return Redirect::to(ADMIN_URL.'security-question');
        } else {
            $securityQuestionList = $this->security_question_list();
            return View::make('members_authenticates.security-question', array(
                'title' => 'Security Question',
                'securityQuestionList' => $securityQuestionList,
                'record' => $record
            ));  
        }
    }
    
    public function getDownloadFile()
    {
        $filePath       = '';
        $filename       = WWW_ROOT . Input::get('folder').'/'.Input::get('file');
        $file_extension = strtolower(substr(strrchr($filename, "."), 1));
        switch ($file_extension) 
        {
            case "pdf": $ctype="application/pdf"; break;
            case "exe": $ctype="application/octet-stream"; break;
            case "zip": $ctype="application/zip"; break;
            case "doc": $ctype="application/msword"; break;
            case "xls": $ctype="application/vnd.ms-excel"; break;
            case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
            case "gif": $ctype="image/gif"; break;
            case "png": $ctype="image/png"; break;
            case "jpe": case "jpeg":
            case "jpg": $ctype="image/jpg"; break;
            default: $ctype="application/force-download";
        }	  
        header("Pragma: public");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private",false);
        header("Content-Type: $ctype");
        header("Content-Disposition: attachment; filename=\"".basename($filename)."\";");
        header("Content-Transfer-Encoding: binary");
        header("Content-Length: ".@filesize($filename));
        @readfile("$filename") or die("File not found.");
        exit;
    }
    
    function delete_temp_img($img)
    {
        if($img != '') {
            if (File::exists(TEMP_IMG_PATH.$img)){
                unlink(TEMP_IMG_PATH.$img);
            }
            if(File::exists(TEMP_IMG_PATH.'thumb/'.$img)){
                unlink(TEMP_IMG_PATH.'thumb/'.$img);
            }
        }
        exit;
    }
    
    public static function security_question_list()
    {
        return array('What was your childhood nickname?','What is the last name of your favorite primary/elementary school teacher','What is the name of your favorite childhood pet?','What time of day were you born?','What is your mother`s middle name?','What is the last name of your favorite high school teacher?','What was your high school mascot?','In what city or town was your first job?','What is the name of the company of your first job?','What is your paternal grandmother`s maiden name?');
    }
    
    
}?>