<?php
class MemberController extends BaseController
{
    protected $returnIds = array(); // return active,inactive, delete ids array
    
    public function getIndex() // Index
    {
        if (Auth::check() && Auth::user()->id == '1' || Auth::user()->e_type == 'Admin') {
            return View::make('member.index')->with(array('title' => 'Member List'));
        } else {
            if (Auth::check() && Auth::user()->e_type != 'Admin') {
                return Redirect::to('dashboard');
            }
            return Redirect::to('/admin');
        }
    }

    public function anyListAjax() //User Listing
    {
        $query = Member::query();
        $Requestdata = Input::all();
        $sortBy = array('v_last_name','email','e_type','e_status');
        
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'v_last_name';
        $order       = Input::get('order') === 'asc' ? 'desc' : 'asc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        
        if ($rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if ($membername != "") {
            $query->where(function($query)use($membername) {
                 $query->orwhere(DB::raw("CONCAT(tbl_members.v_first_name, ' ', tbl_members.v_last_name)"), 'LIKE', "%".$membername."%");
            });
        }
        if ($email != "") {
            $query->where("v_email", 'LIKE', "%" . $email . "%");
        }
        if ($e_type != "") {
            $query->where("e_type", "=", $e_type);
        }
        $current_user = Auth::user()->id;
        $query->where("id", "!=", $current_user);
        $query->where("e_type", "!=",'Admin');
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        
        $NumOfRecords = get_num_of_rec_list();
        
        return View::make('member.list_ajax')->with(array(
            'records' => $records,
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'pagnotr'       =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }

    public function anyAdd() //Add user
    {
        if (Input::all()) {
            $validator = Validator::make(Input::all(), array("v_email" =>
                    'unique:tbl_members,v_email'));
            if ($validator->fails()) {
                return "Email id already exits.";
                exit;
            }
            $member = new Member;
            $member->v_first_name = e(Input::get('v_first_name'));
            $member->v_last_name = e(Input::get('v_last_name'));
            $member->v_email = Input::get('v_email');
            $member->password = Hash::make(Input::get('password'));
            $member->e_type = Input::get('e_type');
            $member->v_student_id = Input::get('v_student_id') != '' ? Input::get('v_student_id') : '';
            $member->i_lesson_id = Input::get('i_lesson_id');
            $member->d_added_date = date('Y-m-d H:m:i',strtotime(Input::get('d_added_date')));
            $member->created_at = date('Y-m-d H:m:i');
            $member->updated_at = date('Y-m-d H:m:i');
            if ($member->save()) {
                $lessionLeavelArr = range(1,$member->i_lesson_id);
                $lession_leavel = array_values($lessionLeavelArr);
                foreach($lession_leavel as $key => $val)
                {
                    $memberLesson = new MemberLesson;
                    $memberLesson->i_lesson_id = $val;
                    $memberLesson->i_member_id = $member->id;
                    //$memberLesson->d_submitted_date = ;
                    $memberLesson->e_status = 'Start';
                    $memberLesson->created_at = date('Y-m-d H:m:i');
                    $memberLesson->save();
                }
                Session::put('message',ADD_SUCCESS);
            }
        } else {
            if (Auth::check() && Auth::user()->e_type == 'Admin') {
                return View::make('member.add')->with(array('title' => 'Add New Member'));
            }
            return Redirect::to('/');
        }
    }
    
    public function anyEdit($id) //User edit section
    {
        if (Input::all()) {
            $member = Member::find($id);
            $validator = Validator::make(Input::all(), array("v_email" =>
                    'unique:tbl_members,v_email,' . $id . ''));
            if ($validator->fails()) {
                return "Email id already exits.";
                exit;
            }
            $lastAssignLesson = $member->i_lesson_id;
            $member->v_first_name = e(Input::get('v_first_name'));
            $member->v_last_name = e(Input::get('v_last_name'));
            $member->v_email = Input::get('v_email');
            $member->e_type = Input::get('e_type');
            $member->v_student_id = Input::get('v_student_id') != '' ? Input::get('v_student_id') : '';
            $member->i_lesson_id = Input::get('i_lesson_id');
            $member->d_added_date = date('Y-m-d H:m:i',strtotime(Input::get('d_added_date')));
            $password = Input::get('password');
            if ($password != '') {
                $member->password = Hash::make($password);
            }
            $member->password = $member->password;
            $member->updated_at = date('Y-m-d H:m:i');
            if($member->save())
            {
                /** if last lesson level and New is same do nothing ---------- 
                 *  if new lesson level is smaller than last lesson level do nothing
                */
                if($lastAssignLesson != $member->i_lesson_id && $lastAssignLesson < $member->i_lesson_id){
                    $lessionLeavelArr = range(1,$member->i_lesson_id);
                    $lession_leavel = array_values($lessionLeavelArr);
                    foreach($lession_leavel as $key => $val)
                    {
                        $lessonsExiting = MemberLesson::where('i_lesson_id',$val)->where('i_member_id',$member->id)->count();
                        /** * Check if same Lesson already Exits than Do Nothing*/
                        if($lessonsExiting == 0){
                            $memberLesson = new MemberLesson;
                            $memberLesson->i_lesson_id = $val;
                            $memberLesson->i_member_id = $member->id;
                            $memberLesson->e_status = 'Start';
                            $memberLesson->created_at = date('Y-m-d H:m:i');
                            $memberLesson->save();
                        };
                        
                    }    
                }
                Session::put('message',EDIT_SUCCESS);
            }
            
        } else {
            $member = Member::find($id);
            return View::make('member.edit')->with(array('record' => $member->toArray()));
        }
    }

    public function postBulkActions() //Bulk Actions
    {
        $data = Input::get('data'); //get action ids
        $action = Input::get('bulk_action'); // action to perform(delete,active,inactive)
        if (count($data) > 0) {
            if ($action == "del") {
                    $memberLesson = MemberLesson::whereIn('i_member_id',$data)->with('member_lesson_answer')->delete();
                    $member = Member::whereIn('id',$data)->delete();
            }
            return $data;
        }
    }

    public function getView($id) //User view
    {
        $member_data = Member::find($id);
        return View::make('member.view')->with(array('record'=>$member_data));

    }

    public function getChangeStatus($status, $id) // Change status actvie/inactive
    {
        $member = Member::find($id);
        $member->e_status = $status;
        $member->save();
    }

    public function getDelete($id)
    {
        if ($id != '') {
            $query = MemberLesson::query();
            $query->where('i_member_id','=',$id)->with('member_lesson_answer');
            $query->delete();
            $member = Member::find($id);
            $member->delete();
       }
    }
    
    public function getExport()
    {
        Excel::create('Members-'.date("Y-m-d-h-i-s"), function($excel)
        {
            $excel->sheet('Members'  , function($sheet)
            {
                
                $query = Member::query();
                $Requestdata = Input::all();
                $sortBy = array('v_user_name','email','e_type','e_status');
                
                $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'updated_at';
                $order       = Input::get('order') === 'desc' ? 'asc' : 'desc';
                
                foreach ($Requestdata as $key => $val) {
                    $$key = trim($val);
                }
                
                if ($rec_per_page != '') {
                    Session::set('REC_LIMIT', $rec_per_page);
                } else {
                    $rec_per_page = Session::get('REC_LIMIT');
                }
                if ($membername != "") {
                    $query->where("v_first_name", 'LIKE', "%" . $membername . "%");
                }
                if ($email != "") {
                    $query->where("v_email", 'LIKE', "%" . $email . "%");
                }
                if ($e_type != "") {
                    $query->where("e_type", "=", $e_type);
                }
                $query->select('v_first_name','v_last_name','v_email', 'e_type', 'v_student_id', 'v_company', 'd_added_date','i_agreed', 'd_agreed_date', 'v_security_question', 'v_security_answer', 'i_lesson_id');
                $records = $query->get()->toArray();
                
                $field['no'] = 'Sr.No';
                $field['v_first_name'] = 'First Name';
                $field['v_last_name'] = 'Last Name';
                $field['v_email'] = 'Email';
                $field['e_type'] = 'Member Type';
                $field['v_student_id'] = 'Student Id' ;
                $field['v_company'] = 'Company';
                $field['d_added_date'] = 'Enrollment Date';
                $field['i_agreed'] = 'Agreed' ;
                $field['d_agreed_date'] = 'Agreed Date';
                $field['v_security_question'] = 'Security Question';
                $field['v_security_answer'] = 'Security Answer';
                $field['i_lesson_id'] = 'Lession Level' ;
                                       
                $sheet->setHeight(1, 30);
                $sheet->mergeCells('A1:N1');
                
                $sheet->cells('A1:N1', function($cell)
                {
                    $cell->setAlignment('center');
                    $cell->setValignment('middle');
                    $cell->setFontSize('20');
                    $cell->setFontWeight('bold');
                });
                
                $sheet->row(1,array('Members'));
                
                $sheet->cells('A2:N2', function($cell)
                {
                    $cell->setAlignment('center');
                    $cell->setValignment('middle');
                    $cell->setFontSize('12');
                    $cell->setFontWeight('bold');
                });
                
                $sheet->row(2,$field);
                
                $intCount = 3;
                $srNo=1;
                $section=array();
                foreach($records as $val){
                    $val['id'] = $srNo;
                    $sheet->row($intCount, $val);
                    $intCount++;
                    $srNo++;
                }
            });
        
        })->download('xlsx');
    }
}?>