<?php
View::composer(
    array(
        'account.index',
        'member.index',
        'member.add',
        'member.edit',
        'lessons.index',
        'account.accounting-record-add',
        'student-lessons.index',
        'messages.index',
        'messages.list_ajax',        
        'messages.add',
        'messages.print',
        'messages.print_list_ajax'
    ), function($view)
{
    $memberList = Member::where('id','!=',1)->orderBy('v_last_name','asc')->get(array('v_first_name','v_last_name','id'))->toArray();
    $lession_levels = Lesson::where('e_status','Active')->lists('v_lesson','id');
    $student_lession_levels = Lesson::where('e_status','Active')->take(Auth::user()->i_lession_id)->lists('v_lesson','id');
    $view->with(array('memberList'=> $memberList,'lession_levels'=> $lession_levels, 'student_lession_levels'=>$student_lession_levels));
});