<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magentocommerce.com for more information.
 *
 * @category    Mage
 * @package     Mage_Directory
 * @copyright   Copyright (c) 2014 Magento Inc. (http://www.magentocommerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

$installer = $this;
/* @var $installer Mage_Core_Model_Resource_Setup */

$installer->startSetup();

$installer->run("

-- DROP TABLE IF EXISTS {$this->getTable('directory_country')};
CREATE TABLE {$this->getTable('directory_country')} (
  `country_id` varchar(2) NOT NULL default '',
  `iso2_code` varchar(2) NOT NULL default '',
  `iso3_code` varchar(3) NOT NULL default '',
  `address_template_plain` text,
  `address_template_html` text,
  PRIMARY KEY  (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Countries';

insert  into {$this->getTable('directory_country')}(`country_id`,`iso2_code`,`iso3_code`,`address_template_plain`,`address_template_html`) values ('AD','AD','AND','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AE','AE','ARE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AF','AF','AFG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AG','AG','ATG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AI','AI','AIA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AL','AL','ALB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AM','AM','ARM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AN','AN','ANT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AO','AO','AGO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AQ','AQ','ATA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AR','AR','ARG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AS','AS','ASM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AT','AT','AUT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AU','AU','AUS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AW','AW','ABW','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('AZ','AZ','AZE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BA','BA','BIH','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BB','BB','BRB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BD','BD','BGD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BE','BE','BEL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BF','BF','BFA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BG','BG','BGR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BH','BH','BHR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BI','BI','BDI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BJ','BJ','BEN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BM','BM','BMU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BN','BN','BRN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BO','BO','BOL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BR','BR','BRA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BS','BS','BHS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BT','BT','BTN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BV','BV','BVT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BW','BW','BWA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BY','BY','BLR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('BZ','BZ','BLZ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CA','CA','CAN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CC','CC','CCK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CF','CF','CAF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CG','CG','COG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CH','CH','CHE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CI','CI','CIV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CK','CK','COK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CL','CL','CHL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CM','CM','CMR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CN','CN','CHN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CO','CO','COL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CR','CR','CRI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CU','CU','CUB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CV','CV','CPV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CX','CX','CXR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CY','CY','CYP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('CZ','CZ','CZE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DE','DE','DEU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DJ','DJ','DJI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DK','DK','DNK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DM','DM','DMA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DO','DO','DOM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('DZ','DZ','DZA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('EC','EC','ECU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('EE','EE','EST','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('EG','EG','EGY','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('EH','EH','ESH','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ER','ER','ERI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ES','ES','ESP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ET','ET','ETH','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FI','FI','FIN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FJ','FJ','FJI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FK','FK','FLK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FM','FM','FSM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FO','FO','FRO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FR','FR','FRA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('FX','FX','FXX','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GA','GA','GAB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GB','GB','GBR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GD','GD','GRD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GE','GE','GEO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GF','GF','GUF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GH','GH','GHA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GI','GI','GIB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GL','GL','GRL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GM','GM','GMB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GN','GN','GIN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GP','GP','GLP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GQ','GQ','GNQ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GR','GR','GRC','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GS','GS','SGS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GT','GT','GTM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GU','GU','GUM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GW','GW','GNB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('GY','GY','GUY','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HK','HK','HKG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HM','HM','HMD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HN','HN','HND','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HR','HR','HRV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HT','HT','HTI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('HU','HU','HUN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ID','ID','IDN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IE','IE','IRL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IL','IL','ISR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IN','IN','IND','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IO','IO','IOT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IQ','IQ','IRQ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IR','IR','IRN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IS','IS','ISL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('IT','IT','ITA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('JM','JM','JAM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('JO','JO','JOR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('JP','JP','JPN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KE','KE','KEN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KG','KG','KGZ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KH','KH','KHM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KI','KI','KIR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KM','KM','COM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KN','KN','KNA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KP','KP','PRK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KR','KR','KOR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KW','KW','KWT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KY','KY','CYM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('KZ','KZ','KAZ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LA','LA','LAO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LB','LB','LBN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LC','LC','LCA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LI','LI','LIE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LK','LK','LKA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LR','LR','LBR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LS','LS','LSO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LT','LT','LTU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LU','LU','LUX','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LV','LV','LVA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('LY','LY','LBY','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MA','MA','MAR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MC','MC','MCO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MD','MD','MDA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MG','MG','MDG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MH','MH','MHL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MK','MK','MKD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ML','ML','MLI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MM','MM','MMR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MN','MN','MNG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MO','MO','MAC','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MP','MP','MNP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MQ','MQ','MTQ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MR','MR','MRT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MS','MS','MSR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MT','MT','MLT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MU','MU','MUS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MV','MV','MDV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MW','MW','MWI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MX','MX','MEX','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MY','MY','MYS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('MZ','MZ','MOZ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NA','NA','NAM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NC','NC','NCL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NE','NE','NER','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NF','NF','NFK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NG','NG','NGA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NI','NI','NIC','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NL','NL','NLD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NO','NO','NOR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NP','NP','NPL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NR','NR','NRU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NU','NU','NIU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('NZ','NZ','NZL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('OM','OM','OMN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PA','PA','PAN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PE','PE','PER','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PF','PF','PYF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PG','PG','PNG','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PH','PH','PHL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PK','PK','PAK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PL','PL','POL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PM','PM','SPM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PN','PN','PCN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PR','PR','PRI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PT','PT','PRT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PW','PW','PLW','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('PY','PY','PRY','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('QA','QA','QAT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('RE','RE','REU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('RO','RO','ROM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('RU','RU','RUS','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('RW','RW','RWA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SA','SA','SAU','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SB','SB','SLB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SC','SC','SYC','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SD','SD','SDN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SE','SE','SWE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SG','SG','SGP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SH','SH','SHN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SI','SI','SVN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SJ','SJ','SJM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SK','SK','SVK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SL','SL','SLE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SM','SM','SMR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SN','SN','SEN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SO','SO','SOM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SR','SR','SUR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ST','ST','STP','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SV','SV','SLV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SY','SY','SYR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('SZ','SZ','SWZ','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TC','TC','TCA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TD','TD','TCD','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TF','TF','ATF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TG','TG','TGO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TH','TH','THA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TJ','TJ','TJK','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TK','TK','TKL','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TM','TM','TKM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TN','TN','TUN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TO','TO','TON','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TR','TR','TUR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TT','TT','TTO','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TV','TV','TUV','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TW','TW','TWN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('TZ','TZ','TZA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('UA','UA','UKR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('UG','UG','UGA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('UM','UM','UMI','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('US','US','USA','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('UY','UY','URY','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('UZ','UZ','UZB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VA','VA','VAT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VC','VC','VCT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VE','VE','VEN','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VG','VG','VGB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VI','VI','VIR','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VN','VN','VNM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('VU','VU','VUT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('WF','WF','WLF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('WS','WS','WSM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('YE','YE','YEM','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('YT','YT','MYT','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ZA','ZA','ZAF','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ZM','ZM','ZMB','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}'),('ZW','ZW','ZWE','{{firstname}} {{lastname}}\n{{company}}\n{{street1}}\n{{street2}}\n{{city}}, {{region}} {{postcode}}','{{firstname}} {{lastname}}<br/>\n{{company}}<br/>\n{{street}}<br/>\n{{city}}, {{region}} {{postcode}}<br/>\nT: {{telephone}}');

-- DROP TABLE IF EXISTS {$this->getTable('directory_country_region')};
CREATE TABLE {$this->getTable('directory_country_region')} (
  `region_id` mediumint(8) unsigned NOT NULL auto_increment,
  `country_id` varchar(4) NOT NULL default '0',
  `code` varchar(32) NOT NULL default '',
  `default_name` varchar(255) default NULL,
  PRIMARY KEY  (`region_id`),
  KEY `FK_REGION_COUNTRY` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Country regions';

insert  into `{$this->getTable('directory_country_region')}` (`region_id`,`country_id`,`code`,`default_name`) VALUES (1,'US','AL','Alabama'),(2,'US','AK','Alaska'),(3,'US','AS','American Samoa'),(4,'US','AZ','Arizona'),(5,'US','AR','Arkansas'),(6,'US','AF','Armed Forces Africa'),(7,'US','AA','Armed Forces Americas'),(8,'US','AC','Armed Forces Canada'),(9,'US','AE','Armed Forces Europe'),(10,'US','AM','Armed Forces Middle East'),(11,'US','AP','Armed Forces Pacific'),(12,'US','CA','California'),(13,'US','CO','Colorado'),(14,'US','CT','Connecticut'),(15,'US','DE','Delaware'),(16,'US','DC','District of Columbia'),(17,'US','FM','Federated States Of Micronesia'),(18,'US','FL','Florida'),(19,'US','GA','Georgia'),(20,'US','GU','Guam'),(21,'US','HI','Hawaii'),(22,'US','ID','Idaho'),(23,'US','IL','Illinois'),(24,'US','IN','Indiana'),(25,'US','IA','Iowa'),(26,'US','KS','Kansas'),(27,'US','KY','Kentucky'),(28,'US','LA','Louisiana'),(29,'US','ME','Maine'),(30,'US','MH','Marshall Islands'),(31,'US','MD','Maryland'),(32,'US','MA','Massachusetts'),(33,'US','MI','Michigan'),(34,'US','MN','Minnesota'),(35,'US','MS','Mississippi'),(36,'US','MO','Missouri'),(37,'US','MT','Montana'),(38,'US','NE','Nebraska'),(39,'US','NV','Nevada'),(40,'US','NH','New Hampshire'),(41,'US','NJ','New Jersey'),(42,'US','NM','New Mexico'),(43,'US','NY','New York'),(44,'US','NC','North Carolina'),(45,'US','ND','North Dakota'),(46,'US','MP','Northern Mariana Islands'),(47,'US','OH','Ohio'),(48,'US','OK','Oklahoma'),(49,'US','OR','Oregon'),(50,'US','PW','Palau'),(51,'US','PA','Pennsylvania'),(52,'US','PR','Puerto Rico'),(53,'US','RI','Rhode Island'),(54,'US','SC','South Carolina'),(55,'US','SD','South Dakota'),(56,'US','TN','Tennessee'),(57,'US','TX','Texas'),(58,'US','UT','Utah'),(59,'US','VT','Vermont'),(60,'US','VI','Virgin Islands'),(61,'US','VA','Virginia'),(62,'US','WA','Washington'),(63,'US','WV','West Virginia'),(64,'US','WI','Wisconsin'),(65,'US','WY','Wyoming'),(66,'CA','AB','Alberta'),(67,'CA','BC','British Columbia'),(68,'CA','MB','Manitoba'),(69,'CA','NF','Newfoundland'),(70,'CA','NB','New Brunswick'),(71,'CA','NS','Nova Scotia'),(72,'CA','NT','Northwest Territories'),(73,'CA','NU','Nunavut'),(74,'CA','ON','Ontario'),(75,'CA','PE','Prince Edward Island'),(76,'CA','QC','Quebec'),(77,'CA','SK','Saskatchewan'),(78,'CA','YT','Yukon Territory'),(79,'DE','NDS','Niedersachsen'),(80,'DE','BAW','Baden-Württemberg'),(81,'DE','BAY','Bayern'),(82,'DE','BER','Berlin'),(83,'DE','BRG','Brandenburg'),(84,'DE','BRE','Bremen'),(85,'DE','HAM','Hamburg'),(86,'DE','HES','Hessen'),(87,'DE','MEC','Mecklenburg-Vorpommern'),(88,'DE','NRW','Nordrhein-Westfalen'),(89,'DE','RHE','Rheinland-Pfalz'),(90,'DE','SAR','Saarland'),(91,'DE','SAS','Sachsen'),(92,'DE','SAC','Sachsen-Anhalt'),(93,'DE','SCN','Schleswig-Holstein'),(94,'DE','THE','Thüringen'),(95,'AT','WI','Wien'),(96,'AT','NO','Niederösterreich'),(97,'AT','OO','Oberösterreich'),(98,'AT','SB','Salzburg'),(99,'AT','KN','Kärnten'),(100,'AT','ST','Steiermark'),(101,'AT','TI','Tirol'),(102,'AT','BL','Burgenland'),(103,'AT','VB','Voralberg'),(104,'CH','AG','Aargau'),(105,'CH','AI','Appenzell Innerrhoden'),(106,'CH','AR','Appenzell Ausserrhoden'),(107,'CH','BE','Bern'),(108,'CH','BL','Basel-Landschaft'),(109,'CH','BS','Basel-Stadt'),(110,'CH','FR','Freiburg'),(111,'CH','GE','Genf'),(112,'CH','GL','Glarus'),(113,'CH','JU','Graubünden'),(114,'CH','JU','Jura'),(115,'CH','LU','Luzern'),(116,'CH','NE','Neuenburg'),(117,'CH','NW','Nidwalden'),(118,'CH','OW','Obwalden'),(119,'CH','SG','St. Gallen'),(120,'CH','SH','Schaffhausen'),(121,'CH','SO','Solothurn'),(122,'CH','SZ','Schwyz'),(123,'CH','TG','Thurgau'),(124,'CH','TI','Tessin'),(125,'CH','UR','Uri'),(126,'CH','VD','Waadt'),(127,'CH','VS','Wallis'),(128,'CH','ZG','Zug'),(129,'CH','ZH','Zürich'),(130,'ES','A Coruсa','A Coruña'),(131,'ES','Alava','Alava'),(132,'ES','Albacete','Albacete'),(133,'ES','Alicante','Alicante'),(134,'ES','Almeria','Almeria'),(135,'ES','Asturias','Asturias'),(136,'ES','Avila','Avila'),(137,'ES','Badajoz','Badajoz'),(138,'ES','Baleares','Baleares'),(139,'ES','Barcelona','Barcelona'),(140,'ES','Burgos','Burgos'),(141,'ES','Caceres','Caceres'),(142,'ES','Cadiz','Cadiz'),(143,'ES','Cantabria','Cantabria'),(144,'ES','Castellon','Castellon'),(145,'ES','Ceuta','Ceuta'),(146,'ES','Ciudad Real','Ciudad Real'),(147,'ES','Cordoba','Cordoba'),(148,'ES','Cuenca','Cuenca'),(149,'ES','Girona','Girona'),(150,'ES','Granada','Granada'),(151,'ES','Guadalajara','Guadalajara'),(152,'ES','Guipuzcoa','Guipuzcoa'),(153,'ES','Huelva','Huelva'),(154,'ES','Huesca','Huesca'),(155,'ES','Jaen','Jaen'),(156,'ES','La Rioja','La Rioja'),(157,'ES','Las Palmas','Las Palmas'),(158,'ES','Leon','Leon'),(159,'ES','Lleida','Lleida'),(160,'ES','Lugo','Lugo'),(161,'ES','Madrid','Madrid'),(162,'ES','Malaga','Malaga'),(163,'ES','Melilla','Melilla'),(164,'ES','Murcia','Murcia'),(165,'ES','Navarra','Navarra'),(166,'ES','Ourense','Ourense'),(167,'ES','Palencia','Palencia'),(168,'ES','Pontevedra','Pontevedra'),(169,'ES','Salamanca','Salamanca'),(170,'ES','Santa Cruz de Tenerife','Santa Cruz de Tenerife'),(171,'ES','Segovia','Segovia'),(172,'ES','Sevilla','Sevilla'),(173,'ES','Soria','Soria'),(174,'ES','Tarragona','Tarragona'),(175,'ES','Teruel','Teruel'),(176,'ES','Toledo','Toledo'),(177,'ES','Valencia','Valencia'),(178,'ES','Valladolid','Valladolid'),(179,'ES','Vizcaya','Vizcaya'),(180,'ES','Zamora','Zamora'),(181,'ES','Zaragoza','Zaragoza');

-- DROP TABLE IF EXISTS {$this->getTable('directory_country_region_name')};
CREATE TABLE {$this->getTable('directory_country_region_name')} (
  `locale` varchar(8) NOT NULL default '',
  `region_id` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`locale`,`region_id`),
  KEY `FK_DIRECTORY_REGION_NAME_REGION` (`region_id`),
  CONSTRAINT `FK_DIRECTORY_REGION_NAME_REGION` FOREIGN KEY (`region_id`) REFERENCES {$this->getTable('directory_country_region')} (`region_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Regions names';

INSERT INTO `{$this->getTable('directory_country_region_name')}` VALUES ('en_US',1,'Alabama'),('en_US',2,'Alaska'),('en_US',3,'American Samoa'),('en_US',4,'Arizona'),('en_US',5,'Arkansas'),('en_US',6,'Armed Forces Africa'),('en_US',7,'Armed Forces Americas'),('en_US',8,'Armed Forces Canada'),('en_US',9,'Armed Forces Europe'),('en_US',10,'Armed Forces Middle East'),('en_US',11,'Armed Forces Pacific'),('en_US',12,'California'),('en_US',13,'Colorado'),('en_US',14,'Connecticut'),('en_US',15,'Delaware'),('en_US',16,'District of Columbia'),('en_US',17,'Federated States Of Micronesia'),('en_US',18,'Florida'),('en_US',19,'Georgia'),('en_US',20,'Guam'),('en_US',21,'Hawaii'),('en_US',22,'Idaho'),('en_US',23,'Illinois'),('en_US',24,'Indiana'),('en_US',25,'Iowa'),('en_US',26,'Kansas'),('en_US',27,'Kentucky'),('en_US',28,'Louisiana'),('en_US',29,'Maine'),('en_US',30,'Marshall Islands'),('en_US',31,'Maryland'),('en_US',32,'Massachusetts'),('en_US',33,'Michigan'),('en_US',34,'Minnesota'),('en_US',35,'Mississippi'),('en_US',36,'Missouri'),('en_US',37,'Montana'),('en_US',38,'Nebraska'),('en_US',39,'Nevada'),('en_US',40,'New Hampshire'),('en_US',41,'New Jersey'),('en_US',42,'New Mexico'),('en_US',43,'New York'),('en_US',44,'North Carolina'),('en_US',45,'North Dakota'),('en_US',46,'Northern Mariana Islands'),('en_US',47,'Ohio'),('en_US',48,'Oklahoma'),('en_US',49,'Oregon'),('en_US',50,'Palau'),('en_US',51,'Pennsylvania'),('en_US',52,'Puerto Rico'),('en_US',53,'Rhode Island'),('en_US',54,'South Carolina'),('en_US',55,'South Dakota'),('en_US',56,'Tennessee'),('en_US',57,'Texas'),('en_US',58,'Utah'),('en_US',59,'Vermont'),('en_US',60,'Virgin Islands'),('en_US',61,'Virginia'),('en_US',62,'Washington'),('en_US',63,'West Virginia'),('en_US',64,'Wisconsin'),('en_US',65,'Wyoming'),('en_US',66,'Alberta'),('en_US',67,'British Columbia'),('en_US',68,'Manitoba'),('en_US',69,'Newfoundland'),('en_US',70,'New Brunswick'),('en_US',71,'Nova Scotia'),('en_US',72,'Northwest Territories'),('en_US',73,'Nunavut'),('en_US',74,'Ontario'),('en_US',75,'Prince Edward Island'),('en_US',76,'Quebec'),('en_US',77,'Saskatchewan'),('en_US',78,'Yukon Territory'),('en_US',79,'Niedersachsen'),('en_US',80,'Baden-Württemberg'),('en_US',81,'Bayern'),('en_US',82,'Berlin'),('en_US',83,'Brandenburg'),('en_US',84,'Bremen'),('en_US',85,'Hamburg'),('en_US',86,'Hessen'),('en_US',87,'Mecklenburg-Vorpommern'),('en_US',88,'Nordrhein-Westfalen'),('en_US',89,'Rheinland-Pfalz'),('en_US',90,'Saarland'),('en_US',91,'Sachsen'),('en_US',92,'Sachsen-Anhalt'),('en_US',93,'Schleswig-Holstein'),('en_US',94,'Thüringen'),('en_US',95,'Wien'),('en_US',96,'Niederösterreich'),('en_US',97,'Oberösterreich'),('en_US',98,'Salzburg'),('en_US',99,'Kärnten'),('en_US',100,'Steiermark'),('en_US',101,'Tirol'),('en_US',102,'Burgenland'),('en_US',103,'Voralberg'),('en_US',104,'Aargau'),('en_US',105,'Appenzell Innerrhoden'),('en_US',106,'Appenzell Ausserrhoden'),('en_US',107,'Bern'),('en_US',108,'Basel-Landschaft'),('en_US',109,'Basel-Stadt'),('en_US',110,'Freiburg'),('en_US',111,'Genf'),('en_US',112,'Glarus'),('en_US',113,'Graubünden'),('en_US',114,'Jura'),('en_US',115,'Luzern'),('en_US',116,'Neuenburg'),('en_US',117,'Nidwalden'),('en_US',118,'Obwalden'),('en_US',119,'St. Gallen'),('en_US',120,'Schaffhausen'),('en_US',121,'Solothurn'),('en_US',122,'Schwyz'),('en_US',123,'Thurgau'),('en_US',124,'Tessin'),('en_US',125,'Uri'),('en_US',126,'Waadt'),('en_US',127,'Wallis'),('en_US',128,'Zug'),('en_US',129,'Zürich'),('en_US',130,'A Coruña'),('en_US',131,'Alava'),('en_US',132,'Albacete'),('en_US',133,'Alicante'),('en_US',134,'Almeria'),('en_US',135,'Asturias'),('en_US',136,'Avila'),('en_US',137,'Badajoz'),('en_US',138,'Baleares'),('en_US',139,'Barcelona'),('en_US',140,'Burgos'),('en_US',141,'Caceres'),('en_US',142,'Cadiz'),('en_US',143,'Cantabria'),('en_US',144,'Castellon'),('en_US',145,'Ceuta'),('en_US',146,'Ciudad Real'),('en_US',147,'Cordoba'),('en_US',148,'Cuenca'),('en_US',149,'Girona'),('en_US',150,'Granada'),('en_US',151,'Guadalajara'),('en_US',152,'Guipuzcoa'),('en_US',153,'Huelva'),('en_US',154,'Huesca'),('en_US',155,'Jaen'),('en_US',156,'La Rioja'),('en_US',157,'Las Palmas'),('en_US',158,'Leon'),('en_US',159,'Lleida'),('en_US',160,'Lugo'),('en_US',161,'Madrid'),('en_US',162,'Malaga'),('en_US',163,'Melilla'),('en_US',164,'Murcia'),('en_US',165,'Navarra'),('en_US',166,'Ourense'),('en_US',167,'Palencia'),('en_US',168,'Pontevedra'),('en_US',169,'Salamanca'),('en_US',170,'Santa Cruz de Tenerife'),('en_US',171,'Segovia'),('en_US',172,'Sevilla'),('en_US',173,'Soria'),('en_US',174,'Tarragona'),('en_US',175,'Teruel'),('en_US',176,'Toledo'),('en_US',177,'Valencia'),('en_US',178,'Valladolid'),('en_US',179,'Vizcaya'),('en_US',180,'Zamora'),('en_US',181,'Zaragoza');

-- DROP TABLE IF EXISTS {$this->getTable('directory_currency_rate')};
CREATE TABLE {$this->getTable('directory_currency_rate')} (
  `currency_from` char(3) NOT NULL default '',
  `currency_to` char(3) NOT NULL default '',
  `rate` decimal(24,12) NOT NULL default '0.0000',
  PRIMARY KEY  (`currency_from`,`currency_to`),
  KEY `FK_CURRENCY_RATE_TO` (`currency_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO {$this->getTable('directory_currency_rate')} (`currency_from`, `currency_to`, `rate`) VALUES ('EUR', 'EUR', 1.000000000000),('EUR', 'USD', 1.415000000000),('USD', 'EUR', 0.706700000000),('USD', 'USD', 1.000000000000);

        ");

$installer->endSetup();
