<?php
require_once 'Mage/Checkout/controllers/CartController.php';

class ZealousWeb_Cutomcaptcha_CartController extends Mage_Checkout_CartController
{
	 public function ajaxDeleteAction()
    {
        if (!$this->_validateFormKey()) {
            Mage::throwException('Invalid form key');
        }
        $id = (int) $this->getRequest()->getParam('id');
        $result = array();
        if ($id) {
            try {
                $this->_getCart()->removeItem($id)->save();

                $result['qty'] = $this->_getCart()->getSummaryQty();

                $this->loadLayout();
				
				$checkoutCart = Mage::getSingleton('checkout/cart');
				$cartGrandTotal = Mage::helper('core')->currency($checkoutCart->getQuote()->getGrandTotal(), true, false);
                
				$result['gtotal'] = $cartGrandTotal;
				$result['content'] = $this->getLayout()->getBlock('minicart_content')->toHtml();

                $result['success'] = 1;
                $result['message'] = $this->__('Item was removed successfully.');
            } catch (Exception $e) {
                $result['success'] = 0;
                $result['error'] = $this->__('Can not remove the item.');
            }
        }

        $this->getResponse()->setHeader('Content-type', 'application/json');
        $this->getResponse()->setBody(Mage::helper('core')->jsonEncode($result));
    }	
}
?>
