<?php
require_once('app/Mage.php');
umask(0);
Mage::app();

$file = fopen('customer.csv', 'r');
$count = 1;
while (($data = fgetcsv($file)) !== FALSE) {
	$count++;

	if($count == 2)
	{
		continue;
	}
	
	$customer = Mage::getModel('customer/customer');
 
	$customer->setWebsiteId(Mage::app()->getWebsite()->getId());
	$customer->loadByEmail($data[8]);
	$customer->setEmail($data[8]);
	$customer->setFirstname($data[4]);
	$customer->setLastname($data[5]);		
	$customer->setCreatedAt(Mage::app()->getLocale()->date(strtotime($data[2]), null, null, false)->toString('yyyy-dd-MM'));
	
	//$newPassword = $customer->generatePassword(); // generate a new password		
	//$customer->setPassword($newPassword); // set it			
	try {
		$customer->save();
	
		$address = Mage::getModel('customer/address');
		
		$address->setCustomerId($customer->getId())
				->setFirstname($data[4])
				->setMiddleName('')
				->setLastname($data[5])
				->setCountryId($data[14])
				->setRegion($data[12]) //state/province, only needed if the country is USA
				->setPostcode($data[15])
				->setCity($data[4])
				->setTelephone($data[7])
				->setFax(' ')
				->setCompany($data[6])
				->setStreet($data[10])
				->setIsDefaultBilling('1')
				->setIsDefaultShipping('1')
				->setSaveInAddressBook('1');		
		$address->save();

		if($data[17] != '')
		{
			$address2 = Mage::getModel('customer/address');

			$address2->setCustomerId($customer->getId())
					->setFirstname($data[17])
					->setMiddleName('')
					->setLastname($data[18])
					->setCountryId($data[23])
					->setRegion($data[21]) //state/province, only needed if the country is USA
					->setPostcode($data[24])
					->setCity($data[20])
					->setTelephone($data[28])
					->setFax(' ')
					->setStreet($data[19])
					->setIsDefaultBilling('0')
					->setIsDefaultShipping('1')
					->setSaveInAddressBook('1');		
			$address2->save();
		}	

		if($data[25] == 'Y')
		{		
			$email = $data[8];
			$subscriber = Mage::getModel('newsletter/subscriber')->subscribe($email);

			if ($customer->getId()){
				$subscriber = Mage::getModel('newsletter/subscriber')->loadByEmail($email);
				if (!$subscriber->getId() 
					|| $subscriber->getStatus() == Mage_Newsletter_Model_Subscriber::STATUS_UNSUBSCRIBED 
					|| $subscriber->getStatus() == Mage_Newsletter_Model_Subscriber::STATUS_NOT_ACTIVE) {
					$subscriber->setStatus(Mage_Newsletter_Model_Subscriber::STATUS_SUBSCRIBED);
					$subscriber->setSubscriberEmail($email);
					$subscriber->setSubscriberConfirmCode($subscriber->RandomSequence());
				}
				$subscriber->setStoreId(Mage::app()->getStore()->getId());
				$subscriber->setCustomerId($customer->getId());
				try {
					$subscriber->save();
				}
				catch (Exception $e) {
					throw new Exception($e->getMessage());
				}
			}		
		}
		
		//$customer->setConfirmation(null);
		//$customer->save();
		//$customer->sendPasswordReminderEmail(); // save successful, send new password
	}
	catch (Exception $ex) {
		Zend_Debug::dump($ex->getMessage());
	}
}
fclose($file);
?>

