@extends('layout.default')
@section('content')
@include('elements.header')

<div id="container" class="row-fluid">
    @include('elements.left_sidebar')
	<div id="main-content">
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="span12">
					<div id="theme-change" class="hidden-phone">
						<i class="icon-cogs"></i>
						<span class="settings">
							<span class="text">Theme:</span>
							<span class="colors">
								<span class="color-default" data-style="default">
								</span>
								<span class="color-gray" data-style="gray">
								</span>
								<span class="color-purple" data-style="purple">
								</span>
								<span class="color-navy-blue" data-style="navy-blue">
								</span>
							</span>
						</span>
					</div>
					<h3 class="page-title">Security Question</h3>
					<ul class="breadcrumb">
						<li>
							<a href="<?php echo ADMIN_URL."dashboard"; ?>"><i class="icon-home"></i></a>
                            <span class="divider">&nbsp;</span>
						</li>
                        <li>
							Security Question
                            <span class="divider-last">&nbsp;</span>
						</li>						
					</ul>
				</div>
			</div>
			<div id="page" class="dashboard">
                <div class="row-fluid">
					<div class="span12">
                        <div class="widget error-container"></div>
						<div class="widget">
							<div class="widget-title">
								<h4><i class="icon-reorder"></i> Security Question</h4>
                                <h4 class="flash-inner-error"><span class="greenMsg"><?php echo Session::get('message'); ?></span></h4>
							</div>
							<div class="widget-body form">

                                {{ Form::open( array('id' => 'frmSecurityQuestion','name' => 'frmSecurityQuestion','class'=>'form-horizontal','enctype' => 'multipart/form-data') ) }}
                                <div class="control-group">
									<label class="control-label">Security Question:<b class='redMsg'>*</b></label>
									<div class="controls">
                                      <select id="v_security_question" name="v_security_question" class="required span6" placeholder="Security Question">
        									@foreach($securityQuestionList as $val)
                                                <?php 
                                                echo '<option value="'.$val.'"';
                                                if($val == $record['v_security_question']) { echo "selected=selected"; }
                                                echo '>'.$val.'</option>';
                                                ?>
                                            @endforeach
                                    </select>                                              
									</div>
                                </div>
                                <div class="control-group">
									<label class="control-label">Enter your answer:<b class='redMsg'>*</b></label>
								    <div class="controls">
										<textarea class="required span6" name="v_security_answer" id="v_security_answer" placeholder="Answer">{{$record['v_security_answer']}}</textarea>
									 </div>
                                </div>
                                
                                <div class="form-actions">
									{{ Form::button('Submit',array('id'=>'frmSecurityQuestion','type'=>'submit','class' => 'btn btn-success btn-submit','div'=>false)) }}
									<button type="button" onclick="window.location.href=ADMIN_URL+'dashboard';" id="redirect-to-user" class="btn">Cancel</button>
								</div>
                                 
								</form>
							</div>
						</div>
					</div>
				</div>								
			</div>
		</div>
	</div>
</div>
@include('elements.footer')
<script>handleSecurityQuestionForm();</script>
@stop