@extends('layout.default')
@section('content')
@include('elements.header')
<div id="container" class="row-fluid policy-and-terms-page">
	<div id="main-content">
		<div class="container-fluid">
			<div class="row-fluid">
				<div class="span12">
					<div id="theme-change" class="hidden-phone">
						<i class="icon-cogs"></i>
						<span class="settings">
							<span class="text">Theme:</span>
							<span class="colors">
								<span class="color-default" data-style="default">
								</span>
								<span class="color-gray" data-style="gray">
								</span>
								<span class="color-purple" data-style="purple">
								</span>
								<span class="color-navy-blue" data-style="navy-blue">
								</span>
							</span>
						</span>
					</div>
					<h3 class="page-title">Terms of Use & Privacy Policy Acceptance</h3>
				</div>
			</div>
			<div id="page" class="dashboard">
                <div class="row-fluid">
					<div class="span12">
                        <div class="widget error-container"></div>
						<div class="widget">
							<div class="widget-title">
								<h4><i class="icon-reorder"></i> Terms of Use & Privacy Policy Acceptance</h4>
                                <h4 class="flash-inner-error"><span class="greenMsg"><?php echo Session::get('message'); ?></span></h4>
							</div>
							<div class="widget-body form">

                                {{ Form::open( array('id' => 'frmPolicyAndTerms','name' =>'frmPolicyAndTerms','class'=>'form-horizontal','enctype' => 'multipart/form-data') ) }}
                                <div class="policy-box">
                                <h5><b>Please review our Terms of Use and Privacy Policy to proceed.</b></h5>
                                </div>
                                <div class="policy-box">
                                    <label><b>TERMS OF USE</b></label>
                                    <div>
                                        <textarea  rows="15" class="span12">{{$terms['v_cms_content']}}</textarea>
                                    </div>
                                </div>
                                <div class="policy-box">
                                    <label><b>PRIVACY POLICY</b></label>
                                    <div>
                                        <textarea  rows="10" class="span12">{{ $pricyPolicy['v_cms_content'] }}</textarea>
                                    </div>
                                </div>
                                <div class="policy-box">
                                    <span>
                                        <a href="{{ADMIN_URL.'policy-and-terms-print'}}" target="_blank">Click here to print the TERMS OF USE and PRIVACY POLICY</a> 
                                        <em>(a printable page will open in a new window or tab)</em>   
                                    </span>
                                </div>                                
                                <div class="policy-box">
										<label class="checkbox line">
											<input name="i_agree" id="i_agree" class="agree" type="checkbox"/>
											<strong>I agree with the Lemurian Fellowship Policy and Terms</strong>
										</label>
								</div>
                                <div class="form-actions">
									{{ Form::button('Submit',array('id'=>'frmSettingsSubmit','type'=>'submit','class' => 'btn btn-success btn-submit','div'=>false)) }}
									<button type="button" onclick="window.location.href=ADMIN_URL+'logout';" id="redirect-to-user" class="btn">Logout</button>
								</div>
                                </form>
							</div>
						</div>
					</div>
				</div>								
			</div>
		</div>
	</div>
</div>
<script>
handlePolicyForm();        
</script>
<style>
.policy-and-terms-page #main-content{ margin:0;}
.policy-and-terms-page .container-fluid{ max-width:1100px; width:100%; margin:0 auto;}
.policy-and-terms-page .container-fluid .breadcrumb{ display:none;}
.policy-box{padding: 10px;}
</style>
@stop