@extends('layout.default')
@section('content')
@include('elements.header')
<div id="container" class="row-fluid list-page">
@include('elements.left_sidebar')

<div id="main-content">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span12">
				<div class="hidden-phone" id="theme-change"><i class="icon-cogs"></i><span class="settings"><span class="text">Theme:</span><span class="colors"><span data-style="default" class="color-default"></span><span data-style="gray" class="color-gray"></span><span data-style="purple" class="color-purple"></span><span data-style="navy-blue" class="color-navy-blue"></span></span></span></div>
				<h3 class="page-title"> Add New Accounting Record</h3>
				<ul class="breadcrumb">
					<li><a href=""><i class="icon-home"></i></a><span class="divider">&nbsp;</span></li>
					<li><a href="<?php echo ADMIN_URL.'accounting-list'; ?>">Accounting List</a><span class="divider">&nbsp;</span></li>
					<li><a href="javascript:;">Add</a><span class="divider-last">&nbsp;</span></li>
				</ul>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12 sortable">
				<div class="widget">
					<div class="widget-title">
						<h4><i class="icon-reorder"></i>Add New Accounting Record</h4>
                        <h4 class="flash-msg">
                            <span class="greenMsg">
                                 <?php //$session_message = Session::get('message');?>
                                 {{Session::get('message')}}
                                 <?php if(isset($message) && $message!=''){ echo $message;}?>
                            </span></h4>
					</div>
					<div class="widget-body" id="userAdd">
						<form class="form-horizontal" action="{{SITE_URL.'accounting-record/add'}}" onsubmit="return false;" method="post" name="frmAdd" id="frmAdd" enctype="multipart/form-data" >
                            <div class="control-group">
    							<label class="control-label">Student Name:<b class="redMsg">*</b></label>
    							<div class="controls">
    								<select id="i_member_id" name="i_member_id" class="required select_msg" placeholder="Student Name">
    									<option value="">--Select--</option>
									    @foreach($memberList as $key => $val)
                                            <?php 
                                            echo '<option value="'.$val['id'].'"';
                                            if($val['id'] == $member_id) { echo "selected=selected"; }
                                            echo '>'.$val['v_last_name']."&nbsp;".$val['v_first_name'].'</option>';
                                            ?>
                                        @endforeach
                                    </select>
    							</div>
						    </div>
                            <div class="control-group">
    							<label class="control-label">Transaction Type:<b class="redMsg">*</b></label>
    							<div class="controls">
    								<select id="e_transaction_type" name="e_transaction_type" class="required select_msg" placeholder="Transaction Type">
    									<option value="">--Select Type--</option>
                                        <option value="Tuition">Tuition</option>
    									<option value="Donation">Donation</option>
    								</select>
    							</div>
						    </div>
                            <div class="control-group">
    							<label class="control-label">Send Email to Student:<b class="redMsg">*</b></label>
    							<div class="controls">
    								<select id="i_send_email" name="i_send_email" class="required" placeholder="Send Email to Student">
    									<option value="1">Yes</option>
    									<option value="0">No</option>
    								</select>
    							</div>
						    </div>
                            <h4><b>Tuition</b></h4>
                            <div class="control-group">
								<label class="control-label">Transaction Date:</label>
								<div class="controls">
                                    <input type="text" name="d_tuition_transaction_date" class="input-large frmDatePicker" placeholder="Transaction Date" size="45" maxlength="255" value="{{date('m/d/Y')}}"/>
								</div>
							</div>
                            <div class="control-group">
								<label class="control-label">Tuition Contract:</label>
								<div class="controls">
									<input type="text" name="f_tuition_Contract" class="input-large" placeholder="Tuition Contract" value="0.00">                        							</div>
							</div>
                            <div class="control-group">
								<label class="control-label">Previous Balance:</label>
								<div class="controls">
									<input type="text" name="f_tuition_prev_balance" class="input-large" placeholder="Previous Balance" value="0.00">                                         </div>
							</div>
                            <div class="control-group">
								<label class="control-label" id="payment_received">Payment Received:</label>
								<div class="controls">
									<input type="text" id="f_tuition_payment_received" name="f_tuition_payment_received" class="input-large" placeholder="Payment Received" value="0.00">                         			
                                </div>
							</div>
                            <div class="control-group">
    							<label class="control-label">Present Balance:</label>
    							<div class="controls">
    									<input type="text" name="f_tuition_present_balance" class="input-large number" placeholder="Present Balance" value="0.00">
                               	</div>
						    </div>
                            <div class="control-group">
								<label class="control-label">Special Note:</label>
								<div class="controls">
                                    <textarea rows="3" name="v_tuition_special_note" class="input-xlarge"></textarea>
                                </div>
							</div>
                            <h4><b>Donation</b></h4>
                            <div class="control-group">
								<label class="control-label">Date Sent:</label>
								<div class="controls">
                                    <input type="text" name="d_donation_sent_date" class="input-large frmDatePicker" placeholder="Date Sent" size="45" maxlength="255" value="{{date('m/d/Y')}}"/>
								</div>
							</div>
                            <div class="control-group">
								<label class="control-label">For Previous Month Of:</label>
								<div class="controls">
									<input type="text" name="v_donation_prev_month" class="input-large" placeholder="Previous Month Donation">                        							</div>
							</div>
                            <div class="control-group">
								<label class="control-label">Basis Of Tithe Amount:</label>
								<div class="controls">
									<input type="text" name="i_donation_basic_tithe_amt" class="input-large number i_donation_basic_tithe_amt" placeholder="Basis Of Tithe Amount" value="0"><span>&nbsp;% (Do not enter % sign)</span>                           
                               </div>
							</div>
                            <div class="control-group">
								<label class="control-label">Tithe Amount:</label>
								<div class="controls">
									<input type="text" name="f_donation_tithe_amt" class="input-large number" placeholder="Tithe Amount" value="0.00">                         			         </div>
							</div>
							<div class="control-group">
								<label class="control-label">Gift Offering:</label>
								<div class="controls">
									<input type="text" name="f_donation_gift_offer" class="input-large number" placeholder="Gift Offering" value="0.00">                         			         </div>
							</div>
                            <div class="control-group">
								<label class="control-label" id="total_amt_lbl">Total Amount:</label>
								<div class="controls">
									<input type="text" name="f_donation_total_amt" id="f_donation_total_amt" class="input-large" placeholder="Total Amount" value="0.00">                         			         </div>
							</div>
                            <div class="control-group">
								<label class="control-label">Member Type:</label>
								<div class="controls">
									<input type="text" name="v_member_type" class="input-large" placeholder="Member Type">                         			                                     </div>
							</div>
                            <div class="control-group">
								<label class="control-label">Receipt Number:</label>
								<div class="controls">
									<input type="text" name="v_receipt_number" class="input-large number" placeholder="Receipt Number">                         			                     </div>
							</div>
                            <div class="control-group">
								<label class="control-label">Date Received:</label>
								<div class="controls">
                                    <input type="text" name="d_date_received" class="input-large frmDatePicker" placeholder="Date Received" size="45" maxlength="255" value="{{date('m/d/Y')}}"/>
								</div>
							</div>
                            <div class="control-group">
								<label class="control-label">Recorded By:</label>
								<div class="controls">
									<input type="text" name="v_recorded_by" class="input-large" placeholder="Recorded By">                         			                              </div>
							</div>
                            <input type="hidden" name="back_url" id="back_url" value="accounting-record-list/"/>
                            <div class="form-actions">
									{{ Form::button('Submit',array('id'=>'frmAddSubmit','name'=>'frmAddSubmit','type'=>'submit','class' => 'btn btn-success','div'=>false)) }}	
                                    <button type="Submit" id="frmAddNewSubmit" name="frmAddNewSubmit" class="btn btn-success">Submit and Add New</button>
									<button type="button" onclick="window.location.href=ADMIN_URL+'{{$previous_page_url}}';" id="redirect-to-home" class="btn">Cancel</button>
							</div>
					</form>
                    </div>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<script>
$(document).ready(function(){
    var transactionType = $('#e_transaction_type option:selected').val();
    if(transactionType != ''){
         validation_for_amount(transactionType);
    }
    $("#e_transaction_type").change(function(){
        validation_for_amount($(this).val());
    });    
});
</script>
@include('elements.footer')
<?php Session::remove('message'); ?>
@endsection