<?php
class MessageController extends BaseController
{
    protected $returnIds = array(); // return active,inactive, delete ids array
    
    public function getIndex() // Index
    {
        if (Auth::check()) {
            $memberList = Member::where('id','!=',1)->orderBy('v_last_name','asc')->get(array('v_first_name','v_last_name','id'))->toArray();
            return View::make('messages.index')->with(array('title' => 'Message List','memberListNew'=> $memberList));
        } else {
            return Redirect::to('dashboard');
        }
    }

    public function anyListAjax() //User Listing
    {
        $currentUser = array();
        $currentUser = Auth::user();
        $currentUser = $currentUser->toArray();
        $query = Message::query();
        $Requestdata = Input::all();
        
        $sort = 'updated_at';
        $order       = 'desc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if(isset($rec_per_page) && $rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if (isset($i_member_id) && $i_member_id != "") {
            $query->where("i_member_id", $i_member_id);
        }
        if (isset($e_status) && $e_status != "") {
            if($currentUser['e_type'] == 'Admin') {
                if($e_status == 'Draft'){
                    $query->where("e_status", 'Draft-Admin');    
                } else {
                    $query->where("e_status",'!=','Draft');
                }
            }
            else {
                if($e_status == 'Draft'){
                    $query->where("e_status",'=','Draft');
                } 
            }    
        }
        if($start_date != "" && $end_date != '')
        {
            $query->orderBy('created_at', 'asc');
            $start_date = date("Y-m-d", strtotime($start_date));
            $end_date = date("Y-m-d", strtotime($end_date));
            $query->where(DB::raw('DATE_FORMAT(`created_at`, "%Y-%m-%d")'),'>=',$start_date)->where(DB::raw('DATE_FORMAT(`created_at`, "%Y-%m-%d")'),'<=',$end_date);
        }
        if($currentUser['e_type'] == 'Admin') {
            /**  Message Admin */
            $query->where("e_status",'!=','Draft');
        } else {
            $query->where("e_status",'!=','Draft-Admin');
            $query->where("e_status",'!=','Deleted');
            $query->where("i_member_id",$currentUser['id']);
        }
        $query->with('member');
        $query->orderBy($sort, $order);
        if(isset($from_section) && $from_section != '' && $from_section == 'print'){
            $records = $query->get();
            return View::make('messages.print_list_ajax')->with(array(
                'records' => $records->toArray(),
                'currentUser' => $currentUser
            ));
        } else {
            $pagination = $query->paginate($rec_per_page);
            $records = $pagination->getCollection();
            $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
            $NumOfRecords = get_num_of_rec_list();    
            return View::make('messages.list_ajax')->with(array(
                'records' => $records->toArray(),
                'currentUser' => $currentUser,
                'pagination' => $pagination_next,
                'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
                'rec_per_page' => $rec_per_page,
                'sort' => $sort,
                'pagnotr'       =>$pagination,
                'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
                'NumOfRecords' => $NumOfRecords
            ));
        }
    }
    
    public function anyAdd() // Message Add and Edit 
    {
        if (Input::all()) 
        {
            $editID = Input::get('edit_message_id');
            if($editID != ''){
                $message =  Message::find($editID);
            } else {
                $message =  new Message;    
            }
            $message->i_member_id = e(trim(Input::get('i_member_id')));
            $message->v_subject = e(trim(Input::get('v_subject')));
            $message->v_message = Input::get('v_message');
            $message->e_status = Input::get('message_status');
            $message->created_at = date('Y-m-d H:i:s');
            $message->updated_at = date('Y-m-d H:i:s');
            if($message->save())
            {
                if($message->e_status == 'Submit'){
                    if(Auth::user()->e_type == 'Admin')
                    {
                        $member = Member::find($message->i_member_id);
                        $userName = $member->v_first_name." ".$member->v_last_name;
                        $this->send_mail_to(3,$member,$userName); // Template Id and MemberInfo
                    } else {
                        $member = Member::where('e_type','Admin')->first();
                        $userName = Auth::user()->v_first_name." ".Auth::user()->v_last_name;
                        $this->send_mail_to(4,$member,$userName); // Template Id and MemberInfo
                    }        
                }
                return '';
            }
        } else {
            return View::make('messages.add')->with(array('title'=>'Add New Message'));
        }
    }

    public function anyEdit($id = '') //Message edit section
    {
        $message = Message::find($id);
        return $message->toArray();
    }
    
    public function getPrint() // Index
    {
        if (Auth::check()) {
            return View::make('messages.print')->with(array('title' => 'Message Print Friendly'));
        } else {
            return Redirect::to('dashboard');
        }
    }
    
    /*public function anyPrint() // Message Print
    {
        $currentUser = Auth::user();
        $currentUser = $currentUser->toArray();
        $query = Message::query();
        $Requestdata = Input::all();
        
        $sort = 'updated_at';
        $order       = 'desc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if ($rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if (isset($i_member_id) && $i_member_id != "") {
            $query->where("i_member_id", $i_member_id);
        }
        if (isset($e_status) && $e_status != "") {
            if($currentUser['e_type'] == 'Admin') {
                if($e_status == 'Draft'){
                    $query->where("e_status", 'Draft-Admin');    
                } else {
                    $query->where("e_status",'!=','Draft');
                }
            }
            else {
                if($e_status == 'Draft'){
                    $query->where("e_status",'=','Draft');
                } 
            }    
        }
        if($start_date != "" && $end_date != '')
        {
            $query->orderBy('created_at', 'asc');
            $start_date = date("Y-m-d", strtotime($start_date));
            $end_date = date("Y-m-d", strtotime($end_date));
            $query->where(DB::raw('DATE_FORMAT(`created_at`, "%Y-%m-%d")'),'>=',$start_date)->where(DB::raw('DATE_FORMAT(`created_at`, "%Y-%m-%d")'),'<=',$end_date);
        }
        if($currentUser['e_type'] == 'Admin') {
            $query->where("e_status",'!=','Draft');
        } else {
            $query->where("e_status",'!=','Draft-Admin');
            $query->where("e_status",'!=','Deleted');
            $query->where("i_member_id",$currentUser['id']);
        }
        $query->with('member');
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        return View::make('message.print')->with(array(
            'title'=>'Lesson Print',
            'records' => $records->toArray(),
            'currentUser' => $currentUser,
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
        ));
    }*/
    
    public function getDelete($id)
    {
        if ($id != '') {
            $message = Message::find($id);
            if($message->e_status =='Draft'){
                $message->delete();
            } else {
                $message->e_status = "Deleted";
                $message->updated_at = date('Y-m-d H:i:s');
                $message->save();    
            }
        }
    }
}?>