<?php
class BaseController extends Controller {
	/**
	 * Setup the layout used by the controller.
	 *
	 * @return void
	 */
	protected function setupLayout()
	{
		if ( ! is_null($this->layout))
		{
			$this->layout = View::make($this->layout);
		}
	}
    
    public function send_mail_to($templateID,$memberInfo, $userName)
    {
        $objEmailTemplate = EmailTemplate::find($templateID);
        $emailSubject = $objEmailTemplate['v_template_subject']; 
        $strTemplate = $objEmailTemplate['t_email_content'];
        $strTemplate = str_replace('[SITE_URL]',SITE_URL,$strTemplate);
        $strTemplate = str_replace('[SITE_NAME]',SITE_NAME,$strTemplate);
        $strTemplate = str_replace('[USERNAME]',$userName,$strTemplate);
        
        /*if (ob_get_length() > 0) {
            ob_end_clean();
        }
        header("Connection: close");
        ignore_user_abort(); 
        ob_start();
        header('HTTP/1.1 200 OK', true, 200);
        echo "";
        $size = ob_get_length();
        header("Content-Length: $size");
        ob_end_flush();
        flush();
        session_write_close();*/
            
        // mail sent to user
        Mail::queue('emails.generate-email-template', array('strTemplate'=>$strTemplate), function($message) use ($memberInfo,$emailSubject)
        {
            $message->to($memberInfo->v_email, $memberInfo->v_first_name." ".$memberInfo->v_last_name);
            $message->subject($emailSubject);                        
        });
    }
}?>