<?php
class AdminLessonsController extends BaseController
{
    protected $returnIds = array(); // return active,inactive, delete ids array
    public function getIndex() // Index
    {
        if (Auth::check() && Auth::user()->id == '1' || Auth::user()->e_type == 'Admin') {
            $memberList = Member::where('id','!=',1)->orderBy('v_last_name','asc')->get(array('v_first_name','v_last_name','id'))->toArray();
            return View::make('lessons.index')->with(array('title' => 'Lession List','memberListNew'=> $memberList));
        } else {
            if (Auth::check() && Auth::user()->e_type != 'Admin') {
                return Redirect::to('dashboard');
            }
            return Redirect::to('/');
        }
    }

    public function anyListAjax() //Lessons Listing
    {
        $query = MemberLesson::query();
        $Requestdata = Input::all();
        $sortBy = array('tbl_members.v_last_name','lession_id','e_status');
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'tbl_members.v_last_name';
        $order       = Input::get('order') === 'asc' ? 'desc' : 'asc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        
        if ($rec_per_page != '') {
            Session::set('REC_LIMIT', $rec_per_page);
        } else {
            $rec_per_page = Session::get('REC_LIMIT');
        }
        if ($member_id != "") {
            $query->where("i_member_id",$member_id);
        }
        if ($lesson_id != "") {
            $query->where("tbl_member_lesson.i_lesson_id", $lesson_id);
        }
        if ($e_status != "") {
            $query->where("tbl_member_lesson.e_status", $e_status);
        }
        $query->where('tbl_member_lesson.e_status','!=','Start');
        $query->join('tbl_members', 'tbl_members.id', '=', 'tbl_member_lesson.i_member_id');
        $query->join('tbl_lesson', 'tbl_lesson.id', '=', 'tbl_member_lesson.i_lesson_id');
        $query->select('tbl_members.id as member_id','tbl_members.v_first_name','tbl_members.v_last_name','tbl_lesson.id as lesson_id', 'tbl_lesson.v_lesson','tbl_member_lesson.*');
       // $query->orderByRaw("FIELD(tbl_member_lesson.e_status, \"Partial Submitted\", \"Submitted\", \"Saved\", \"Reviewed\")");
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        
        $NumOfRecords = get_num_of_rec_list();
        
        return View::make('lessons.list_ajax')->with(array(
            'records' => $records->toArray(),
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'desc' || null ? 'asc' : 'desc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'pagnotr'       =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }

    public function anyEdit($id) //lesson Review section
    {
        if (Input::all()) {
            $lesson = MemberLesson::where('id',$id)->with('member')->first();
            $lastStatus = trim($lesson->e_status);
            $lesson->v_reviewed_by = Input::get('v_reviewed_by');
            $lesson->v_reviewed_comment = e(trim(Input::get('v_reviewed_comment')));
            $member = Member::find($lesson->i_member_id);
	    if(($lastStatus != 'Reviewed' && e(trim(Input::get('lesson_status'))) == 'Reviewed') || ($lastStatus != 'Partial Reviewed' && e(trim(Input::get('lesson_status'))) == 'Partial Reviewed')){
                $lesson->d_reviewed_date = date('Y-m-d H:i:s');
                $lesson->e_status = e(trim(Input::get('lesson_status')));
            }
            if($lastStatus != 'Reviewed' && e(trim(Input::get('lesson_status'))) == 'Reviewed'){
                // Add 1+ Lesson Level for User
                if($lesson->member->i_lesson_id != '' && $lesson->member->i_lesson_id != 12 ){ //Lession Level
                    $newLesson = new MemberLesson;
                    $newLesson->i_lesson_id = $lesson->member->i_lesson_id + 1;
                    $newLesson->i_member_id = $lesson->i_member_id;
                    $newLesson->e_status = 'Start';
                    $newLesson->created_at = date('Y-m-d H:m:i');
                    $newLesson->save();
                    $member->i_lesson_id = $member->i_lesson_id + 1;
                    $member->save();       
                }
            }
            if($lesson->save())
            {
                if(($lastStatus != 'Reviewed' && e(trim(Input::get('lesson_status'))) == 'Reviewed')|| ($lastStatus != 'Partial Reviewed' && e(trim(Input::get('lesson_status'))) == 'Partial Reviewed')) {
                    $userName = $member->v_first_name." ".$member->v_last_name;
                    /** Send Mail to user that your lession is reviewed a new lession*/
                    $this->send_mail_to(6,$member,$userName); // Send Message
                }
                Session::put('message',EDIT_SUCCESS);
            }
        } else {
            $memberLesson = MemberLesson::where('id',$id)->with('member')->with('lesson')->first()->toArray();
            $allQuestionAnswer = $this->get_question_answer_array($memberLesson['i_lesson_id'],$id); /** Get Question and There Answer List* ***/
            return View::make('lessons.edit')->with(array('record' => $memberLesson,'memberlessonAnswer'=>$allQuestionAnswer));
        }
    }

    public function anyPrint($id) // Lesson Print
    {
        $memberLesson = MemberLesson::where('id',$id)->with('member')->with('lesson')->first()->toArray();
        $allQuestionAnswer = $this->get_question_answer_array($memberLesson['i_lesson_id'],$id); /** Get Question and There Answer List* ***/
        return View::make('lessons.print')->with(array('title'=>'Lesson Print', 'record' => $memberLesson,'memberlessonAnswer'=>$allQuestionAnswer));
    }
    
    public static function get_question_answer_array($lessonID,$memberLessonID)
    {
        return  $memberlessonAnswer = MemberLessonAnswer::where('i_member_lesson_id',$memberLessonID)
            ->with(array('lesson_question' => function($lesson_question) use($lessonID){
                $lesson_question->where('i_lesson_id',$lessonID);
            }))->get()->toArray();
    }
}?>