<?php
class AccountController extends BaseController
{
    protected $returnIds = array(); // return active,inactive, delete ids array
    
    public function getIndex() // Index
    {
        if (Auth::check() && Auth::user()->id == '1' || Auth::user()->e_type == 'Admin') {
            $memberList = Member::where('id','!=',1)->orderBy('v_last_name','asc')->get(array('v_first_name','v_last_name','id'))->toArray();
            return View::make('account.index')->with(array('title' => 'Accounting List','memberListNew'=> $memberList));
        } else {
            if (Auth::check() && Auth::user()->e_type != 'Admin') {
                return Redirect::to('dashboard');
            }
            return Redirect::to('/');
        }
    }

    public function anyListAjax() //Member Listing
    {
        $query = Member::query();
        $Requestdata = Input::all();
        $sortBy = array('e_status','v_last_name');
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'v_last_name';
        $order       = Input::get('order') === 'asc' ? 'desc' : 'asc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if (isset($user_id) && $user_id != "") {
            $query->where('id',$user_id);
        }
        $query->where('id','!=',1);
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        //pr($records);exit;
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        
        $NumOfRecords = get_num_of_rec_list();
        
        return View::make('account.list_ajax')->with(array(
            'records' => $records,
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'pagnotr'       =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }
    
    public function accountingRecordIndex($id) // Index
    {
        $memberDetails = Member::find($id);
        $memberDetails = $memberDetails->toArray();
        $member_name = $memberDetails['v_first_name']."&nbsp".$memberDetails['v_last_name'];
        return View::make('account.accounting-record-list')->with(array('title' => $member_name.' - Accounting Record List', 'record' => $memberDetails));
    }
    
    public function accountingRecordListAjax($id) // Index
    {
        $query = Account::query();
        $Requestdata = Input::all();
        $sortBy = array('e_status');
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'updated_at';
        $order       = Input::get('order') === 'desc' ? 'asc' : 'desc';
        
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if (isset($transaction_type) && $transaction_type != "") {
            $query->where("e_transaction_type", "=", $transaction_type);
        }
        if($transaction_date_from != '' && $transaction_date_to != '')
        {
            $query->whereBetween('d_tuition_transaction_date',array(date('Y-m-d H:i:s', strtotime($transaction_date_from)),date('Y-m-d H:i:s', strtotime($transaction_date_to))));
            $query->orWhereBetween('d_donation_sent_date',array(date('Y-m-d H:i:s', strtotime($transaction_date_from)),date('Y-m-d H:i:s', strtotime($transaction_date_to))));
        }
        else
        {
            if ($transaction_date_from != "") {
                $query->where("d_tuition_transaction_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_from)));
                $query->orWhere("d_donation_sent_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_from)));
            }
            if ($transaction_date_to != "") {
                $query->where("d_tuition_transaction_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_to)));
                $query->orWhere("d_tuition_transaction_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_to)));
            }
        }
        $query->where('i_member_id',$id);
        $query->join('tbl_members', 'tbl_members.id', '=', 'tbl_accounting.i_member_id');
        $query->select('tbl_members.id as member_id','tbl_members.v_first_name','tbl_members.v_last_name','tbl_accounting.*');
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        
        $NumOfRecords = get_num_of_rec_list();
        
        return View::make('account.accounting-record-list-ajax')->with(array(
            'records' => $records,
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'sort' => $sort,
            'member_id' => $id,
            'pagnotr' =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }
    
    public function accountingRecordView($id) //Member Account Tranction view
    {
        $transactionDetail = Account::where('id',$id)->with('member')->first()->toArray();
        return View::make('account.accounting-record-view')->with(array('record'=>$transactionDetail));
    }

    public function accountingRecordAdd($id = '',$last_url ='') //Add user
    {
        if (Input::all()) {
           // pr(Input::all());exit;
            $accountingRecord = new Account;
            $accountingRecord->e_transaction_type = Input::get('e_transaction_type');
            if(Input::get('e_transaction_type') == 'Tuition')
            {
                $accountingRecord->i_member_id = Input::get('i_member_id');
                $accountingRecord->i_send_email = Input::get('i_send_email');
                $accountingRecord->d_tuition_transaction_date = date('Y-m-d H:i:s', strtotime(Input::get('d_tuition_transaction_date')));
                $accountingRecord->f_tuition_Contract = Input::get('f_tuition_Contract');
                $accountingRecord->f_tuition_prev_balance = Input::get('f_tuition_prev_balance');
                $accountingRecord->f_tuition_payment_received = Input::get('f_tuition_payment_received');
                $accountingRecord->f_tuition_present_balance = Input::get('f_tuition_present_balance');
                $accountingRecord->v_tuition_special_note = Input::get('v_tuition_special_note');    
            } else {
                $accountingRecord->i_member_id = Input::get('i_member_id');
                $accountingRecord->d_donation_sent_date = date('Y-m-d H:i:s', strtotime(Input::get('d_donation_sent_date')));
                $accountingRecord->v_donation_prev_month = Input::get('v_donation_prev_month');
                $accountingRecord->i_donation_basic_tithe_amt = Input::get('i_donation_basic_tithe_amt');
                $accountingRecord->f_donation_tithe_amt = Input::get('f_donation_tithe_amt');
                $accountingRecord->f_donation_gift_offer = Input::get('f_donation_gift_offer');
                $accountingRecord->f_donation_total_amt = Input::get('f_donation_total_amt');
                $accountingRecord->v_member_type = Input::get('v_member_type');
                $accountingRecord->v_receipt_number = Input::get('v_receipt_number');
                $accountingRecord->d_date_received = date('Y-m-d H:i:s', strtotime(Input::get('d_date_received')));
                $accountingRecord->v_recorded_by = Input::get('v_recorded_by');    
            }
            $accountingRecord->created_at = date("Y-m-d H:i:s");
            $accountingRecord->updated_at = date("Y-m-d H:i:s");
            if ($accountingRecord->save()) {
                Session::flash('message',ADD_SUCCESS);
                if(Input::get('i_send_email') == 1){
                    $this->send_email(Input::get('i_member_id'));        
                }
                return '';
            }
        } else {
            if (Auth::check() && Auth::user()->e_type == 'Admin') {
                $member_id = '';
                $member_id = $id;
                $previous_page_url = '';
                $previous_page_url = $last_url != ''? str_replace('+','/',$last_url) : '';
                if($previous_page_url == ''){
                   $previous_page_url =  'accounting-list';//static Previous URl
                }
                return View::make('account.accounting-record-add')->with(array(
                    'previous_page_url' => $previous_page_url,
                    'member_id' => $member_id,
                    'title' => 'Add New Record'
                    ));
            }
            return Redirect::to('/');
        }
    }
    
    public function accountingRecordEdit($id) //Accounting Record edit section
    {
        $accountRecord = Account::where('id',$id)->with('member')->first()->toArray();
        if (Input::all()) {
            $accountingRecord = Account::find($id);
            if($accountRecord['e_transaction_type'] == 'Tuition')
            {
                $accountingRecord->d_tuition_transaction_date = date('Y-m-d H:i:s', strtotime(Input::get('d_tuition_transaction_date')));
                $accountingRecord->f_tuition_Contract = Input::get('f_tuition_Contract');
                $accountingRecord->f_tuition_prev_balance = Input::get('f_tuition_prev_balance');
                $accountingRecord->f_tuition_payment_received = Input::get('f_tuition_payment_received');
                $accountingRecord->f_tuition_present_balance = Input::get('f_tuition_present_balance');
                $accountingRecord->v_tuition_special_note = Input::get('v_tuition_special_note');    
            } else {
                $accountingRecord->d_donation_sent_date = date('Y-m-d H:i:s', strtotime(Input::get('d_donation_sent_date')));
                $accountingRecord->v_donation_prev_month = Input::get('v_donation_prev_month');
                $accountingRecord->i_donation_basic_tithe_amt = Input::get('i_donation_basic_tithe_amt');
                $accountingRecord->f_donation_tithe_amt = Input::get('f_donation_tithe_amt');
                $accountingRecord->f_donation_gift_offer = Input::get('f_donation_gift_offer');
                $accountingRecord->f_donation_total_amt = Input::get('f_donation_total_amt');
                $accountingRecord->v_member_type = Input::get('v_member_type');
                $accountingRecord->v_receipt_number = Input::get('v_receipt_number');
                $accountingRecord->d_date_received = date('Y-m-d H:i:s', strtotime(Input::get('d_date_received')));
                $accountingRecord->v_recorded_by = Input::get('v_recorded_by');    
            }
            $accountingRecord->updated_at = date("Y-m-d H:i:s");
            if($accountingRecord->save())
            {
                Session::put('message',EDIT_SUCCESS);
                return '';
            }
        } else {
            return View::make('account.accounting-record-edit')->with(array('record' => $accountRecord));
        }
    }

    public function postBulkActions() //Bulk Actions
    {
        $data = Input::get('data'); //get action ids
        $action = Input::get('bulk_action'); // action to perform(delete,active,inactive)
        if (count($data) > 0) {
            if ($action == "del") {
                for ($p = 0; $p < count($data); $p++) {
                    $accountingRecord = Account::find($data[$p]);
                    $accountingRecord->delete();
                    array_push($this->returnIds,$data[$p]);
                }
            }
            return $this->returnIds;
        }
    }

    public function deleteTransaction($id)
    {
        if ($id != '') {
            $accountingRecord = Account::find($id);
            $accountingRecord->delete();
        }
    }
    
    
    public function send_email($id)
    {
        $memberInfo = Member::find($id);
        $objEmailTemplate = EmailTemplate::find(2);
        $emailSubject = $objEmailTemplate['v_template_subject']; 
        $strTemplate = $objEmailTemplate['t_email_content'];
        $strTemplate = str_replace('[SITE_URL]',SITE_URL,$strTemplate);
        $strTemplate = str_replace('[SITE_NAME]',SITE_NAME,$strTemplate);
        $strTemplate = str_replace('[USERNAME]',$memberInfo->v_first_name." ".$memberInfo->v_last_name,$strTemplate);
        //ob_end_clean();
        /*if (ob_get_contents()) ob_end_clean();        
        header("Connection: close");
        ignore_user_abort(); 
        ob_start();
        header('HTTP/1.1 200 OK', true, 200);
        echo "";
        $size = ob_get_length();
        header("Content-Length: $size");
        ob_end_flush();
        flush();
        session_write_close();*/
        Mail::queue('emails.generate-email-template', array('strTemplate'=>$strTemplate),function($message) use ($memberInfo,$emailSubject)
        {
            $message->to($memberInfo->v_email, $memberInfo->v_first_name." ".$memberInfo->v_last_name);
            $message->subject($emailSubject);                        
        });
    }
    
    public function getStudentAccountList($transactionType = '')
    {
        if (Auth::check() && Auth::user()->id != '1' || Auth::user()->e_type != 'Admin') {
            return View::make('account.student-accounting-list')->with(array('title' => 'Student Accounting List','transactionType'=>$transactionType));
        } else {
                return Redirect::to('dashboard');
        }  
    }
    
    public function anyStudentAccountListAjax() //Student Accounting Listing
    {
        $query = Account::query();
        $Requestdata = Input::all();
        $sortBy = array('e_status');
        $sort = in_array(Input::get('sort'), $sortBy) ? Input::get('sort') :  'updated_at';
        $order       = Input::get('order') === 'desc' ? 'asc' : 'desc';
        $set_transaction = 'Tuition';
        foreach ($Requestdata as $key => $val) {
            $$key = trim($val);
        }
        if (isset($transaction_type) && $transaction_type != "") {
            $set_transaction = $transaction_type;
            $query->where("e_transaction_type", "=", $transaction_type);
        }
        if(isset($transaction_date_from) && $transaction_date_from != '' && isset($transaction_date_to) && $transaction_date_to != '')
        {
            if($transaction_type == 'Tuition')
            {
                $query->where('d_tuition_transaction_date',array(date('Y-m-d H:i:s', strtotime($transaction_date_from)),date('Y-m-d H:i:s', strtotime($transaction_date_to))));    
            } else {
                $query->where('d_donation_sent_date',array(date('Y-m-d H:i:s', strtotime($transaction_date_from)),date('Y-m-d H:i:s', strtotime($transaction_date_to))));    
            }
        }
        else
        {
            if (isset($transaction_date_from) && $transaction_date_from != "" && $transaction_type == 'Tuition') {
                $query->where("d_tuition_transaction_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_from)));
            }
            if (isset($transaction_date_to) &&  $transaction_date_to != "" && $transaction_type == 'Donation') {
                $query->orWhere("d_tuition_transaction_date", ">=" , date('Y-m-d H:i:s', strtotime($transaction_date_to)));
            }
        }
        $query->where('i_member_id',Auth::user()->id);
        $query->join('tbl_members', 'tbl_members.id', '=', 'tbl_accounting.i_member_id');
        $query->select('tbl_members.id as member_id','tbl_members.v_first_name','tbl_members.v_last_name','tbl_accounting.*');
        $query->orderBy($sort, $order);
        $pagination = $query->paginate($rec_per_page);
        $records = $pagination->getCollection();
        $pagination_next = $pagination->appends(array('sort' => $sort, 'order' => $order))->links();
        
        $NumOfRecords = get_num_of_rec_list();
        return View::make('account.student-accounting-list-ajax')->with(array(
            'records' => $records,
            'pagination' => $pagination_next,
            'querystr' => '&order=' . (Input::get('order') == 'asc' || null ? 'desc' : 'asc'),
            'rec_per_page' => $rec_per_page,
            'transaction_type' => $set_transaction,
            'sort' => $sort,
            'member_id' => Auth::user()->id,
            'pagnotr' =>$pagination,
            'order' => (Input::get('order') == 'desc' || null ? 'desc' : 'asc'),
            'NumOfRecords' => $NumOfRecords));
    }
    
    public function anyStudentAccountDetailPrint ($id = '')
    {
        if (Auth::check() && Auth::user()->id != '1' || Auth::user()->e_type != 'Admin') {
            $accountingRecord = Account::where('id',$id)->with('member')->first()->toArray();
            return View::make('account.student-accounting-detail-print')->with(array('title' => 'Student Accounting Details Print','record'=>$accountingRecord));
        } 
    } 
    
    public function anyPayment($transactionType = '')
    {
        if (Auth::check() && Auth::user()->id != '1' || Auth::user()->e_type != 'Admin') {
            $title = 'Submit a donation';
            if($transactionType == 'tuition')
            {
                $title = 'Submit a payment';    
            }
            return View::make('account.student-payment')->with(array('title' => $title,'transactionType'=>$transactionType));
        } else {
            return Redirect::to('dashboard');
        } 
    }    
} 